/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.types;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;
import org.apache.axis2.databinding.types.NonNegativeInteger;

public class PositiveInteger
extends NonNegativeInteger {
    private static final long serialVersionUID = -4562301423231920813L;
    private BigInteger iMinInclusive = new BigInteger("1");

    public PositiveInteger(byte[] val) {
        super(val);
        this.checkValidity();
    }

    public PositiveInteger(int signum, byte[] magnitude) {
        super(signum, magnitude);
        this.checkValidity();
    }

    public PositiveInteger(int bitLength, int certainty, Random rnd) {
        super(bitLength, certainty, rnd);
        this.checkValidity();
    }

    public PositiveInteger(int numBits, Random rnd) {
        super(numBits, rnd);
        this.checkValidity();
    }

    public PositiveInteger(String val) {
        super(val);
        this.checkValidity();
    }

    public PositiveInteger(String val, int radix) {
        super(val, radix);
        this.checkValidity();
    }

    private void checkValidity() {
        if (this.compareTo(this.iMinInclusive) < 0) {
            throw new NumberFormatException(":  " + String.valueOf(this));
        }
    }

    @Override
    public Object writeReplace() throws ObjectStreamException {
        return new BigIntegerRep(this.toByteArray());
    }

    protected static class BigIntegerRep
    implements Serializable {
        private static final long serialVersionUID = 1251664160936150499L;
        private byte[] array;

        protected BigIntegerRep(byte[] array) {
            this.array = array;
        }

        protected Object readResolve() throws ObjectStreamException {
            return new PositiveInteger(this.array);
        }
    }
}

