/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.maven.wsdl2java;

import com.github.veithen.ulog.PlexusLoggerInjector;
import java.io.File;
import java.net.MalformedURLException;
import javax.xml.namespace.QName;
import org.apache.axis.constants.Scope;
import org.apache.axis.tools.maven.shared.nsmap.Mapping;
import org.apache.axis.tools.maven.shared.nsmap.MappingUtil;
import org.apache.axis.tools.maven.wsdl2java.CustomizableBaseTypeMapping;
import org.apache.axis.tools.maven.wsdl2java.EmitterEx;
import org.apache.axis.tools.maven.wsdl2java.JavaGeneratorFactoryEx;
import org.apache.axis.tools.maven.wsdl2java.JavaXmlTypeMapping;
import org.apache.axis.wsdl.gen.GeneratorFactory;
import org.apache.axis.wsdl.symbolTable.BaseTypeMapping;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.xml.sax.EntityResolver;

public abstract class AbstractWsdl2JavaMojo
extends AbstractMojo {
    PlexusLoggerInjector loggerInjector;
    private MavenProject project;
    private File file;
    private String url;
    private File catalog;
    private String deployScope;
    private Mapping[] mappings;
    private String typeMappingVersion;
    private String generate;
    private String implementationClassName;
    private boolean skeleton;
    private boolean all;
    private boolean wrapArrays;
    private boolean noWrapped;
    private boolean helperGen;
    private boolean allowInvalidURL;
    private File deployWsdd;
    private File undeployWsdd;
    private JavaXmlTypeMapping[] javaXmlTypeMappings;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String wsdlUrl;
        if (this.file != null && this.url != null) {
            throw new MojoFailureException("Invalid plugin configuration: either use file or url, but not both!");
        }
        if (this.file != null) {
            try {
                wsdlUrl = this.file.toURL().toExternalForm();
            }
            catch (MalformedURLException ex) {
                throw new MojoExecutionException("Unexpected exception", (Exception)ex);
            }
        } else if (this.url != null) {
            wsdlUrl = this.url;
        } else {
            throw new MojoFailureException("Invalid plugin configuration: file or url must be given!");
        }
        EmitterEx emitter = new EmitterEx();
        if (this.generate.equals("client")) {
            emitter.setClientSide(true);
            emitter.setServerSide(false);
        } else if (this.generate.equals("server")) {
            emitter.setClientSide(false);
            emitter.setServerSide(true);
        } else if (this.generate.equals("both")) {
            emitter.setClientSide(true);
            emitter.setServerSide(true);
        } else {
            throw new MojoExecutionException("Invalid value '" + this.generate + "' for the 'generate' parameter");
        }
        if (this.deployWsdd != null) {
            emitter.setDeployWsdd(this.deployWsdd.getAbsolutePath());
        }
        if (this.undeployWsdd != null) {
            emitter.setUndeployWsdd(this.undeployWsdd.getAbsolutePath());
        }
        emitter.setFactory((GeneratorFactory)new JavaGeneratorFactoryEx(emitter));
        Scope scope = Scope.getScope((String)this.deployScope, null);
        if (scope != null) {
            emitter.setScope(scope);
        } else if (this.deployScope != null) {
            this.getLog().warn((CharSequence)("Unrecognized scope:  " + this.deployScope + ".  Ignoring it."));
        }
        if (this.mappings != null && this.mappings.length > 0) {
            emitter.setNamespaceMap(MappingUtil.getNamespaceToPackageMap((Mapping[])this.mappings));
        }
        emitter.setHelperWanted(this.helperGen);
        emitter.setAllWanted(this.all);
        emitter.setSkeletonWanted(this.skeleton);
        emitter.setTypeMappingVersion(this.typeMappingVersion);
        emitter.setNowrap(this.noWrapped);
        emitter.setAllowInvalidURL(this.allowInvalidURL);
        emitter.setWrapArrays(this.wrapArrays);
        emitter.setImplementationClassName(this.implementationClassName);
        if (this.javaXmlTypeMappings != null && this.javaXmlTypeMappings.length > 0) {
            GeneratorFactory factory = emitter.getFactory();
            CustomizableBaseTypeMapping btm = new CustomizableBaseTypeMapping(factory.getBaseTypeMapping());
            for (int i = 0; i < this.javaXmlTypeMappings.length; ++i) {
                String xmlTypeName = this.javaXmlTypeMappings[i].getXmlType();
                if (xmlTypeName.length() == 0 || xmlTypeName.charAt(0) != '{') {
                    throw new MojoFailureException("Invalid XML type '" + xmlTypeName + "'");
                }
                int idx = xmlTypeName.indexOf(125, 1);
                if (idx == -1) {
                    throw new MojoFailureException("Invalid XML type '" + xmlTypeName + "'");
                }
                btm.addMapping(new QName(xmlTypeName.substring(1, idx), xmlTypeName.substring(idx + 1)), this.javaXmlTypeMappings[i].getJavaType());
            }
            factory.setBaseTypeMapping((BaseTypeMapping)btm);
        }
        this.configureEmitter(emitter);
        if (this.catalog != null) {
            CatalogManager catalogManager = new CatalogManager();
            catalogManager.setCatalogFiles(this.catalog.getAbsolutePath());
            emitter.setEntityResolver((EntityResolver)new CatalogResolver(catalogManager));
        }
        this.getLog().info((CharSequence)("Processing " + wsdlUrl));
        try {
            emitter.run(wsdlUrl);
        }
        catch (Exception ex) {
            throw new MojoFailureException("wsdl2java failed", (Throwable)ex);
        }
        this.addSourceRoot(this.project);
    }

    protected abstract void configureEmitter(EmitterEx var1);

    protected abstract void addSourceRoot(MavenProject var1);
}

