/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.maven.java2wsdl;

import com.github.veithen.ulog.PlexusLoggerInjector;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.axis.tools.maven.shared.nsmap.Mapping;
import org.apache.axis.tools.maven.shared.nsmap.MappingUtil;
import org.apache.axis.wsdl.fromJava.Emitter;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractGenerateWsdlMojo
extends AbstractMojo {
    PlexusLoggerInjector loggerInjector;
    private MavenProject project;
    private String className;
    private String[] extraClasses;
    private String namespace;
    private Mapping[] mappings;
    private String style;
    private String use;
    private String location;
    private String portTypeName;
    private File output;

    protected MavenProject getProject() {
        return this.project;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        List classpath;
        try {
            classpath = this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException("Unexpected exception", (Exception)((Object)ex));
        }
        URL[] urls = new URL[classpath.size()];
        for (int i = 0; i < classpath.size(); ++i) {
            try {
                urls[i] = new File((String)classpath.get(i)).toURL();
                continue;
            }
            catch (MalformedURLException ex) {
                throw new MojoExecutionException("Unexpected exception", (Exception)ex);
            }
        }
        URLClassLoader cl = new URLClassLoader(urls);
        Emitter emitter = new Emitter();
        if (this.mappings != null && this.mappings.length > 0) {
            emitter.setNamespaceMap(MappingUtil.getPackageToNamespaceMap((Mapping[])this.mappings));
        }
        try {
            emitter.setCls(cl.loadClass(this.className));
        }
        catch (ClassNotFoundException ex) {
            throw new MojoFailureException("Class " + this.className + " not found");
        }
        if (this.extraClasses != null) {
            Class[] loadedExtraClasses = new Class[this.extraClasses.length];
            for (int i = 0; i < this.extraClasses.length; ++i) {
                try {
                    loadedExtraClasses[i] = cl.loadClass(this.extraClasses[i]);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    throw new MojoExecutionException("Extra class not found: " + this.extraClasses[i]);
                }
            }
            emitter.setExtraClasses(loadedExtraClasses);
        }
        if (this.style != null) {
            emitter.setStyle(this.style);
        }
        if (this.use != null) {
            emitter.setUse(this.use);
        }
        emitter.setIntfNamespace(this.namespace);
        emitter.setLocationUrl(this.location);
        if (this.portTypeName != null) {
            emitter.setPortTypeName(this.portTypeName);
        }
        this.output.getParentFile().mkdirs();
        try {
            emitter.emit(this.output.getAbsolutePath(), 0);
        }
        catch (Exception ex) {
            throw new MojoFailureException("java2wsdl failed", (Throwable)ex);
        }
        this.postProcess(emitter, this.output);
    }

    protected abstract void postProcess(Emitter var1, File var2) throws MojoExecutionException, MojoFailureException;
}

