/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ContainerStatus {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ContainerStatus newInstance(ContainerId containerId, ContainerState containerState, String diagnostics, int exitStatus) {
        ContainerStatus containerStatus = Records.newRecord(ContainerStatus.class);
        containerStatus.setState(containerState);
        containerStatus.setContainerId(containerId);
        containerStatus.setDiagnostics(diagnostics);
        containerStatus.setExitStatus(exitStatus);
        return containerStatus;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ContainerId getContainerId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setContainerId(ContainerId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ContainerState getState();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setState(ContainerState var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int getExitStatus();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setExitStatus(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getDiagnostics();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setDiagnostics(String var1);
}

