/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class CountersBlock
extends HtmlBlock {
    Job job;
    Task task;
    Counters total;
    Counters map;
    Counters reduce;

    @Inject
    CountersBlock(AppContext appCtx, View.ViewContext ctx) {
        super(ctx);
        this.getCounters(appCtx);
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        String urlId;
        String urlBase;
        if (this.job == null) {
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{"Sorry, no counters for nonexistent", this.$("job.id", "job")})))._();
            return;
        }
        if (!this.$("task.id").isEmpty() && this.task == null) {
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{"Sorry, no counters for nonexistent", this.$("task.id", "task")})))._();
            return;
        }
        if (this.total == null || this.total.getGroupNames() == null || this.total.countCounters() == 0) {
            String type = this.$("task.id");
            if (type == null || type.isEmpty()) {
                type = this.$("job.id", "the job");
            }
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{"Sorry it looks like ", type, " has no counters."})))._();
            return;
        }
        if (this.task != null) {
            urlBase = "singletaskcounter";
            urlId = MRApps.toString(this.task.getID());
        } else {
            urlBase = "singlejobcounter";
            urlId = MRApps.toString(this.job.getID());
        }
        int numGroups = 0;
        HamletSpec.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.THEAD)((Hamlet.TABLE)((Hamlet.DIV)html.div(".info-wrap.ui-widget-content.ui-corner-bottom")).table("#counters")).thead()).tr()).th(".group.ui-state-default", "Counter Group")).th(".ui-state-default", "Counters")))._())._()).tbody();
        for (CounterGroup g : this.total) {
            CounterGroup mg = this.map == null ? null : (CounterGroup)this.map.getGroup(g.getName());
            CounterGroup rg = this.reduce == null ? null : (CounterGroup)this.reduce.getGroup(g.getName());
            ++numGroups;
            HamletSpec._Tr groupHeadRow = ((Hamlet.TR)((Hamlet.THEAD)((Hamlet.TABLE)((Hamlet.TABLE)((Hamlet.TD)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TH)((Hamlet.TH)((Hamlet.TH)((Hamlet.TR)((Hamlet.TBODY)tbody).tr()).th()).$title(g.getName())).$class("ui-state-default"))._(new Object[]{this.fixGroupDisplayName(g.getDisplayName())})))._()).td()).$class("table")).table(".dt-counters")).$id(this.job.getID() + "." + g.getName())).thead()).tr()).th(".name", "Name");
            if (this.map != null) {
                ((Hamlet.TR)((Hamlet.TR)groupHeadRow).th("Map")).th("Reduce");
            }
            HamletSpec.TBODY group = ((Hamlet.TABLE)((Hamlet.THEAD)((HamletImpl.EImp)((Object)((Hamlet.TR)groupHeadRow).th(this.map == null ? "Value" : "Total")))._())._()).tbody();
            for (Counter counter : g) {
                HamletSpec.TR groupRow = ((Hamlet.TBODY)group).tr();
                if (this.task == null && mg == null && rg == null) {
                    ((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TD)((Hamlet.TR)groupRow).td()).$title(counter.getName()))._(new Object[]{counter.getDisplayName()})))._();
                } else {
                    ((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TD)((Hamlet.TR)groupRow).td()).$title(counter.getName())).a(this.url(urlBase, urlId, g.getName(), counter.getName()), counter.getDisplayName())))._();
                }
                if (this.map != null) {
                    Counter mc = mg == null ? null : (Counter)mg.findCounter(counter.getName());
                    Counter rc = rg == null ? null : (Counter)rg.findCounter(counter.getName());
                    ((Hamlet.TR)((Hamlet.TR)groupRow).td(mc == null ? "0" : String.format("%,d", mc.getValue()))).td(rc == null ? "0" : String.format("%,d", rc.getValue()));
                }
                ((HamletImpl.EImp)((Object)((Hamlet.TR)groupRow).td(String.format("%,d", counter.getValue()))))._();
            }
            ((Hamlet.TR)((Hamlet.TD)((Hamlet.TABLE)((HamletImpl.EImp)((Object)group))._())._())._())._();
        }
        ((Hamlet.DIV)((Hamlet.TABLE)((HamletImpl.EImp)((Object)tbody))._())._())._();
    }

    private void getCounters(AppContext ctx) {
        JobId jobID = null;
        TaskId taskID = null;
        String tid = this.$("task.id");
        if (!tid.isEmpty()) {
            taskID = MRApps.toTaskID(tid);
            jobID = taskID.getJobId();
        } else {
            String jid = this.$("job.id");
            if (jid != null && !jid.isEmpty()) {
                jobID = MRApps.toJobID(jid);
            }
        }
        if (jobID == null) {
            return;
        }
        this.job = ctx.getJob(jobID);
        if (this.job == null) {
            return;
        }
        if (taskID != null) {
            this.task = this.job.getTask(taskID);
            if (this.task == null) {
                return;
            }
            this.total = this.task.getCounters();
            return;
        }
        Map<TaskId, Task> tasks = this.job.getTasks();
        this.total = this.job.getAllCounters();
        boolean needTotalCounters = false;
        if (this.total == null) {
            this.total = new Counters();
            needTotalCounters = true;
        }
        this.map = new Counters();
        this.reduce = new Counters();
        for (Task t : tasks.values()) {
            Counters counters = t.getCounters();
            if (counters == null) continue;
            switch (t.getType()) {
                case MAP: {
                    this.map.incrAllCounters(counters);
                    break;
                }
                case REDUCE: {
                    this.reduce.incrAllCounters(counters);
                }
            }
            if (!needTotalCounters) continue;
            this.total.incrAllCounters(counters);
        }
    }

    private String fixGroupDisplayName(CharSequence name) {
        return name.toString().replace(".", ".\u200b").replace("$", "\u200b$");
    }
}

