/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.avro.reflect.ReflectData;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class InduceMojo
extends AbstractMojo {
    private File sourceDirectory;
    private File outputDirectory;
    protected MavenProject project;

    public void execute() throws MojoExecutionException {
        ClassLoader classLoader = this.getClassLoader();
        for (File inputFile : this.sourceDirectory.listFiles()) {
            String className = this.parseClassName(inputFile.getPath());
            Class<?> klass = this.loadClass(classLoader, className);
            String fileName = this.outputDirectory.getPath() + "/" + this.parseFileName(klass);
            File outputFile = new File(fileName);
            outputFile.getParentFile().mkdirs();
            try {
                PrintWriter writer = new PrintWriter(fileName, "UTF-8");
                if (klass.isInterface()) {
                    writer.println(ReflectData.get().getProtocol(klass).toString(true));
                } else {
                    writer.println(ReflectData.get().getSchema(klass).toString(true));
                }
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String parseClassName(String fileName) {
        String indentifier = "java/";
        int index = fileName.lastIndexOf(indentifier);
        String namespacedFileName = fileName.substring(index + indentifier.length());
        return namespacedFileName.replace("/", ".").replace(".java", "");
    }

    private String parseFileName(Class klass) {
        String className = klass.getName().replace(".", "/");
        if (klass.isInterface()) {
            return className.concat(".avpr");
        }
        return className.concat(".avsc");
    }

    private Class<?> loadClass(ClassLoader classLoader, String className) {
        Class<?> klass = null;
        try {
            klass = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return klass;
    }

    private ClassLoader getClassLoader() {
        URLClassLoader classLoader = null;
        try {
            List classpathElements = this.project.getRuntimeClasspathElements();
            if (null == classpathElements) {
                return Thread.currentThread().getContextClassLoader();
            }
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
            }
            classLoader = new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classLoader;
    }
}

