/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import org.apache.activemq.artemis.core.management.impl.view.ConsumerField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerConsumer;

public class ConsumerFilterPredicate
extends ActiveMQFilterPredicate<ServerConsumer> {
    private ConsumerField f;
    private final ActiveMQServer server;

    public ConsumerFilterPredicate(ActiveMQServer server) {
        this.server = server;
    }

    @Override
    public boolean test(ServerConsumer consumer) {
        if (this.f == null) {
            return true;
        }
        return switch (this.f) {
            case ConsumerField.ID -> this.matches(consumer.getSequentialID());
            case ConsumerField.SESSION -> this.matches(consumer.getSessionID());
            case ConsumerField.USER -> this.matches(this.server.getSessionByID(consumer.getSessionID()).getUsername());
            case ConsumerField.VALIDATED_USER -> this.matches(this.server.getSessionByID(consumer.getSessionID()).getValidatedUser());
            case ConsumerField.ADDRESS -> this.matches(consumer.getQueue().getAddress());
            case ConsumerField.QUEUE -> this.matches(consumer.getQueue().getName());
            case ConsumerField.FILTER -> this.matches(consumer.getFilterString());
            case ConsumerField.PROTOCOL -> this.matches(this.server.getSessionByID(consumer.getSessionID()).getRemotingConnection().getProtocolName());
            case ConsumerField.CLIENT_ID -> this.matches(this.server.getSessionByID(consumer.getSessionID()).getRemotingConnection().getClientID());
            case ConsumerField.LOCAL_ADDRESS -> this.matches(this.server.getSessionByID(consumer.getSessionID()).getRemotingConnection().getTransportConnection().getLocalAddress());
            case ConsumerField.REMOTE_ADDRESS -> this.matches(this.server.getSessionByID(consumer.getSessionID()).getRemotingConnection().getTransportConnection().getRemoteAddress());
            case ConsumerField.MESSAGES_IN_TRANSIT -> this.matches(consumer.getMessagesInTransit());
            case ConsumerField.MESSAGES_IN_TRANSIT_SIZE -> this.matches(consumer.getMessagesInTransitSize());
            case ConsumerField.MESSAGES_DELIVERED -> this.matches(consumer.getMessagesDelivered());
            case ConsumerField.MESSAGES_DELIVERED_SIZE -> this.matches(consumer.getMessagesDeliveredSize());
            case ConsumerField.MESSAGES_ACKNOWLEDGED -> this.matches(consumer.getMessagesAcknowledged());
            case ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT -> this.matches(consumer.getMessagesAcknowledgedAwaitingCommit());
            case ConsumerField.LAST_ACKNOWLEDGED_TIME -> this.matches(consumer.getLastAcknowledgedTime());
            case ConsumerField.LAST_DELIVERED_TIME -> this.matches(consumer.getLastDeliveredTime());
            default -> true;
        };
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.isEmpty()) {
            this.f = ConsumerField.valueOfName(field);
            if (this.f == null) {
                this.f = ConsumerField.valueOf(field);
            }
        }
    }
}

