/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.arrow.driver.jdbc.converter.impl.BinaryAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.BinaryViewAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.BoolAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.DateAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.DecimalAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.DurationAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.FixedSizeBinaryAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.FixedSizeListAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.FloatingPointAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.IntAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.IntervalAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.LargeBinaryAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.LargeListAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.LargeUtf8AvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.ListAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.MapAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.NullAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.StructAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.TimeAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.TimestampAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.UnionAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.Utf8AvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.Utf8ViewAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.sql.FlightSqlColumnMetadata;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaParameter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.proto.Common;
import org.apache.arrow.driver.jdbc.utils.SqlTypes;

public final class ConvertUtils {
    private ConvertUtils() {
    }

    public static List<ColumnMetaData> convertArrowFieldsToColumnMetaDataList(List<Field> fields) {
        return Stream.iterate(0, Math::incrementExact).limit(fields.size()).map(index -> {
            Field field = (Field)fields.get((int)index);
            ArrowType fieldType = field.getType();
            Common.ColumnMetaData.Builder builder = Common.ColumnMetaData.newBuilder().setOrdinal((int)index).setColumnName(field.getName()).setLabel(field.getName());
            ConvertUtils.setOnColumnMetaDataBuilder(builder, field.getMetadata());
            builder.setType(Common.AvaticaType.newBuilder().setId(SqlTypes.getSqlTypeIdFromArrowType(fieldType)).setName(SqlTypes.getSqlTypeNameFromArrowType(fieldType)).build());
            return ColumnMetaData.fromProto(builder.build());
        }).collect(Collectors.toList());
    }

    public static void setOnColumnMetaDataBuilder(Common.ColumnMetaData.Builder builder, Map<String, String> metadataMap) {
        String remarks;
        Boolean searchable;
        Boolean readOnly;
        Boolean caseSensitive;
        Boolean isAutoIncrement;
        Integer scale;
        Integer precision;
        String tableName;
        String schemaName;
        FlightSqlColumnMetadata columnMetadata = new FlightSqlColumnMetadata(metadataMap);
        String catalogName = columnMetadata.getCatalogName();
        if (catalogName != null) {
            builder.setCatalogName(catalogName);
        }
        if ((schemaName = columnMetadata.getSchemaName()) != null) {
            builder.setSchemaName(schemaName);
        }
        if ((tableName = columnMetadata.getTableName()) != null) {
            builder.setTableName(tableName);
        }
        if ((precision = columnMetadata.getPrecision()) != null) {
            builder.setPrecision(precision);
        }
        if ((scale = columnMetadata.getScale()) != null) {
            builder.setScale(scale);
        }
        if ((isAutoIncrement = columnMetadata.isAutoIncrement()) != null) {
            builder.setAutoIncrement(isAutoIncrement);
        }
        if ((caseSensitive = columnMetadata.isCaseSensitive()) != null) {
            builder.setCaseSensitive(caseSensitive);
        }
        if ((readOnly = columnMetadata.isReadOnly()) != null) {
            builder.setReadOnly(readOnly);
        }
        if ((searchable = columnMetadata.isSearchable()) != null) {
            builder.setSearchable(searchable);
        }
        if ((remarks = columnMetadata.getRemarks()) != null) {
            builder.setLabel(remarks);
        }
    }

    public static List<AvaticaParameter> convertArrowFieldsToAvaticaParameters(List<Field> fields) {
        return fields.stream().map(field -> field.getType().accept(new ConverterVisitor((Field)field))).collect(Collectors.toList());
    }

    private static class ConverterVisitor
    implements ArrowType.ArrowTypeVisitor<AvaticaParameter> {
        private final Field field;

        private ConverterVisitor(Field field) {
            this.field = field;
        }

        @Override
        public AvaticaParameter visit(ArrowType.Null type) {
            return new NullAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.Struct type) {
            return new StructAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.List type) {
            return new ListAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.LargeList type) {
            return new LargeListAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.FixedSizeList type) {
            return new FixedSizeListAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.Union type) {
            return new UnionAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.Map type) {
            return new MapAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.Int type) {
            return new IntAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.FloatingPoint type) {
            return new FloatingPointAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.Utf8 type) {
            return new Utf8AvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.Utf8View type) {
            return new Utf8ViewAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.LargeUtf8 type) {
            return new LargeUtf8AvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.Binary type) {
            return new BinaryAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.BinaryView type) {
            return new BinaryViewAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.LargeBinary type) {
            return new LargeBinaryAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.FixedSizeBinary type) {
            return new FixedSizeBinaryAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.Bool type) {
            return new BoolAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.Decimal type) {
            return new DecimalAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.Date type) {
            return new DateAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.Time type) {
            return new TimeAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.Timestamp type) {
            return new TimestampAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.Interval type) {
            return new IntervalAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.Duration type) {
            return new DurationAvaticaParameterConverter(type).createParameter(this.field);
        }

        @Override
        public AvaticaParameter visit(ArrowType.ListView type) {
            throw new UnsupportedOperationException("AvaticaParameter not yet supported for type " + String.valueOf(type));
        }

        @Override
        public AvaticaParameter visit(ArrowType.LargeListView type) {
            throw new UnsupportedOperationException("AvaticaParameter not yet supported for type " + String.valueOf(type));
        }

        @Override
        public AvaticaParameter visit(ArrowType.RunEndEncoded type) {
            throw new UnsupportedOperationException("No Avatica parameter binder implemented for type " + String.valueOf(type));
        }
    }
}

