/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.annotation.Contract;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.ContentType;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.nio.StreamChannel;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public abstract class AbstractCharAsyncEntityProducer
implements AsyncEntityProducer {
    private static final CharBuffer EMPTY = CharBuffer.wrap(new char[0]);
    private final ByteBuffer bytebuf;
    private final int fragmentSizeHint;
    private final ContentType contentType;
    private final CharsetEncoder charsetEncoder;
    private final ReentrantLock lock;
    private volatile State state;

    public AbstractCharAsyncEntityProducer(int bufferSize, int fragmentSizeHint, ContentType contentType) {
        Args.positive(bufferSize, "Buffer size");
        this.fragmentSizeHint = fragmentSizeHint >= 0 ? fragmentSizeHint : 0;
        this.bytebuf = ByteBuffer.allocate(bufferSize);
        this.contentType = contentType;
        Charset charset = ContentType.getCharset(contentType, StandardCharsets.UTF_8);
        this.charsetEncoder = charset.newEncoder();
        this.state = State.ACTIVE;
        this.lock = new ReentrantLock();
    }

    private void flush(StreamChannel<ByteBuffer> channel) throws IOException {
        if (this.bytebuf.position() > 0) {
            this.bytebuf.flip();
            channel.write(this.bytebuf);
            this.bytebuf.compact();
        }
    }

    final int writeData(StreamChannel<ByteBuffer> channel, CharBuffer src) throws IOException {
        int chunk = src.remaining();
        if (chunk == 0) {
            return 0;
        }
        int p = src.position();
        CoderResult result = this.charsetEncoder.encode(src, this.bytebuf, false);
        if (result.isError()) {
            result.throwException();
        }
        if (!this.bytebuf.hasRemaining() || this.bytebuf.position() >= this.fragmentSizeHint) {
            this.flush(channel);
        }
        return src.position() - p;
    }

    final void streamEnd(StreamChannel<ByteBuffer> channel) throws IOException {
        if (this.state == State.ACTIVE) {
            CoderResult result2;
            CoderResult result;
            this.state = State.FLUSHING;
            if (!this.bytebuf.hasRemaining()) {
                this.flush(channel);
            }
            if ((result = this.charsetEncoder.encode(EMPTY, this.bytebuf, true)).isError()) {
                result.throwException();
            }
            if ((result2 = this.charsetEncoder.flush(this.bytebuf)).isError()) {
                result.throwException();
            } else if (result.isUnderflow()) {
                this.flush(channel);
                if (this.bytebuf.position() == 0) {
                    this.state = State.END_STREAM;
                    channel.endStream();
                }
            }
        }
    }

    protected abstract int availableData();

    protected abstract void produceData(StreamChannel<CharBuffer> var1) throws IOException;

    @Override
    public final String getContentType() {
        return Objects.toString(this.contentType, null);
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public Set<String> getTrailerNames() {
        return null;
    }

    @Override
    public final int available() {
        if (this.state == State.ACTIVE) {
            return this.availableData();
        }
        this.lock.lock();
        try {
            int n = this.bytebuf.position();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void produce(final DataStreamChannel channel) throws IOException {
        this.lock.lock();
        try {
            if (this.state == State.ACTIVE) {
                this.produceData(new StreamChannel<CharBuffer>(){

                    @Override
                    public int write(CharBuffer src) throws IOException {
                        Args.notNull(src, "Buffer");
                        AbstractCharAsyncEntityProducer.this.lock.lock();
                        try {
                            int n = AbstractCharAsyncEntityProducer.this.writeData(channel, src);
                            return n;
                        }
                        finally {
                            AbstractCharAsyncEntityProducer.this.lock.unlock();
                        }
                    }

                    @Override
                    public void endStream() throws IOException {
                        AbstractCharAsyncEntityProducer.this.lock.lock();
                        try {
                            AbstractCharAsyncEntityProducer.this.streamEnd(channel);
                        }
                        finally {
                            AbstractCharAsyncEntityProducer.this.lock.unlock();
                        }
                    }
                });
            }
            if (this.state == State.FLUSHING) {
                CoderResult result = this.charsetEncoder.flush(this.bytebuf);
                if (result.isError()) {
                    result.throwException();
                } else if (result.isOverflow()) {
                    this.flush(channel);
                } else if (result.isUnderflow()) {
                    this.flush(channel);
                    if (this.bytebuf.position() == 0) {
                        this.state = State.END_STREAM;
                        channel.endStream();
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void releaseResources() {
        this.state = State.ACTIVE;
        this.charsetEncoder.reset();
    }

    static enum State {
        ACTIVE,
        FLUSHING,
        END_STREAM;

    }
}

