/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.client.utils;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.arrow.driver.jdbc.client.utils.FlightClientCache;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.Location;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public final class FlightLocationQueue
implements Iterator<Location> {
    private final Deque<Location> locations = new ArrayDeque<Location>();
    private final Deque<Location> badLocations = new ArrayDeque<Location>();

    public FlightLocationQueue(@Nullable FlightClientCache flightClientCache, List<Location> locations) {
        for (Location location : locations) {
            if (flightClientCache != null && flightClientCache.isDud(location.toString())) {
                this.badLocations.add(location);
                continue;
            }
            this.locations.add(location);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.locations.isEmpty() || !this.badLocations.isEmpty();
    }

    @Override
    public Location next() {
        if (!this.locations.isEmpty()) {
            return this.locations.pop();
        }
        if (!this.badLocations.isEmpty()) {
            return this.badLocations.pop();
        }
        throw new NoSuchElementException();
    }
}

