/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth;

import java.util.Optional;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.Context;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.Contexts;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.Metadata;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.ServerCall;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.ServerCallHandler;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.ServerInterceptor;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.Status;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.StatusRuntimeException;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth.AuthConstants;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth.ServerAuthHandler;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.grpc.StatusUtils;

public class ServerAuthInterceptor
implements ServerInterceptor {
    private final ServerAuthHandler authHandler;

    public ServerAuthInterceptor(ServerAuthHandler authHandler) {
        this.authHandler = authHandler;
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        if (!call.getMethodDescriptor().getFullMethodName().equals(AuthConstants.HANDSHAKE_DESCRIPTOR_NAME)) {
            Optional<String> peerIdentity;
            try {
                peerIdentity = this.isValid(headers);
            }
            catch (FlightRuntimeException e) {
                Status grpcStatus = StatusUtils.toGrpcStatus(e.status());
                call.close(grpcStatus, new Metadata());
                return new NoopServerCallListener();
            }
            catch (StatusRuntimeException e) {
                Metadata trailers = e.getTrailers();
                call.close(e.getStatus(), trailers == null ? new Metadata() : trailers);
                return new NoopServerCallListener();
            }
            if (!peerIdentity.isPresent()) {
                call.close(Status.UNAUTHENTICATED.withDescription("Unauthenticated (invalid or missing auth token)"), new Metadata());
                return new NoopServerCallListener();
            }
            return Contexts.interceptCall(Context.current().withValue(AuthConstants.PEER_IDENTITY_KEY, peerIdentity.get()), call, headers, next);
        }
        return next.startCall(call, headers);
    }

    private Optional<String> isValid(Metadata headers) {
        byte[] token = headers.get(AuthConstants.TOKEN_KEY);
        return this.authHandler.isValid(token);
    }

    private static class NoopServerCallListener<T>
    extends ServerCall.Listener<T> {
        private NoopServerCallListener() {
        }
    }
}

