/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.calendar;

import java.sql.SQLException;
import java.time.Duration;
import java.time.Period;
import java.util.function.IntSupplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.IntervalMonthDayNanoVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.PeriodDuration;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.holders.NullableIntervalDayHolder;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.holders.NullableIntervalMonthDayNanoHolder;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.holders.NullableIntervalYearHolder;
import org.apache.arrow.driver.jdbc.utils.IntervalStringUtils;

public class ArrowFlightJdbcIntervalVectorAccessor
extends ArrowFlightJdbcAccessor {
    private final BaseFixedWidthVector vector;
    private final StringGetter stringGetter;
    private final Class<?> objectClass;

    public ArrowFlightJdbcIntervalVectorAccessor(IntervalDayVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.vector = vector;
        this.stringGetter = index -> {
            NullableIntervalDayHolder holder = new NullableIntervalDayHolder();
            vector.get(index, holder);
            if (holder.isSet == 0) {
                return null;
            }
            int days = holder.days;
            int millis = holder.milliseconds;
            return IntervalStringUtils.formatIntervalDay(Duration.ofDays(days).plusMillis(millis));
        };
        this.objectClass = Duration.class;
    }

    public ArrowFlightJdbcIntervalVectorAccessor(IntervalYearVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.vector = vector;
        this.stringGetter = index -> {
            NullableIntervalYearHolder holder = new NullableIntervalYearHolder();
            vector.get(index, holder);
            if (holder.isSet == 0) {
                return null;
            }
            int interval = holder.value;
            int years = interval / 12;
            int months = interval % 12;
            return IntervalStringUtils.formatIntervalYear(Period.ofYears(years).plusMonths(months));
        };
        this.objectClass = Period.class;
    }

    public ArrowFlightJdbcIntervalVectorAccessor(IntervalMonthDayNanoVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.vector = vector;
        this.stringGetter = index -> {
            NullableIntervalMonthDayNanoHolder holder = new NullableIntervalMonthDayNanoHolder();
            vector.get(index, holder);
            if (holder.isSet == 0) {
                return null;
            }
            int months = holder.months;
            int days = holder.days;
            long nanos = holder.nanoseconds;
            Period period = Period.ofMonths(months).plusDays(days);
            Duration duration = Duration.ofNanos(nanos);
            return new PeriodDuration(period, duration).toISO8601IntervalString();
        };
        this.objectClass = PeriodDuration.class;
    }

    @Override
    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    @Override
    public String getString() throws SQLException {
        String result = this.stringGetter.get(this.getCurrentRow());
        this.wasNull = result == null;
        this.wasNullConsumer.setWasNull(this.wasNull);
        return result;
    }

    @Override
    public Object getObject() {
        Object object = this.vector.getObject(this.getCurrentRow());
        this.wasNull = object == null;
        this.wasNullConsumer.setWasNull(this.wasNull);
        return object;
    }

    @FunctionalInterface
    static interface StringGetter {
        public String get(int var1);
    }
}

