/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.SQLException;
import org.apache.arrow.driver.jdbc.ArrowFlightConnection;
import org.apache.arrow.driver.jdbc.ArrowFlightInfoStatement;
import org.apache.arrow.driver.jdbc.client.ArrowFlightSqlClientHandler;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaStatement;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.arrow.driver.jdbc.utils.ConvertUtils;

public class ArrowFlightStatement
extends AvaticaStatement
implements ArrowFlightInfoStatement {
    ArrowFlightStatement(ArrowFlightConnection connection, Meta.StatementHandle handle, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(connection, handle, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public ArrowFlightConnection getConnection() throws SQLException {
        return (ArrowFlightConnection)super.getConnection();
    }

    @Override
    public FlightInfo executeFlightInfoQuery() throws SQLException {
        ArrowFlightSqlClientHandler.PreparedStatement preparedStatement = this.getConnection().getMeta().getPreparedStatement(this.handle);
        Meta.Signature signature = this.getSignature();
        if (signature == null) {
            return null;
        }
        Schema resultSetSchema = preparedStatement.getDataSetSchema();
        signature.columns.addAll(ConvertUtils.convertArrowFieldsToColumnMetaDataList(resultSetSchema.getFields()));
        this.setSignature(signature);
        return preparedStatement.executeQuery();
    }
}

