/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.client;

import java.net.HttpCookie;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallHeaders;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallInfo;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallStatus;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightClientMiddleware;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.VisibleForTesting;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.Logger;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.LoggerFactory;

public class ClientCookieMiddleware
implements FlightClientMiddleware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientCookieMiddleware.class);
    private static final String SET_COOKIE_HEADER = "Set-Cookie";
    private static final String COOKIE_HEADER = "Cookie";
    private final Factory factory;

    @VisibleForTesting
    ClientCookieMiddleware(Factory factory) {
        this.factory = factory;
    }

    @Override
    public void onBeforeSendingHeaders(CallHeaders outgoingHeaders) {
        String cookieValue = this.getValidCookiesAsString();
        if (!cookieValue.isEmpty()) {
            outgoingHeaders.insert(COOKIE_HEADER, cookieValue);
        }
    }

    @Override
    public void onHeadersReceived(CallHeaders incomingHeaders) {
        Iterable<String> setCookieHeaders = incomingHeaders.getAll(SET_COOKIE_HEADER);
        if (setCookieHeaders != null) {
            this.factory.updateCookies(setCookieHeaders);
        }
    }

    @Override
    public void onCallCompleted(CallStatus status) {
    }

    @VisibleForTesting
    String getValidCookiesAsString() {
        this.factory.cookies.entrySet().removeIf(cookieEntry -> ((HttpCookie)cookieEntry.getValue()).hasExpired());
        return this.factory.cookies.entrySet().stream().map(cookie -> ((HttpCookie)cookie.getValue()).toString()).collect(Collectors.joining("; "));
    }

    public static class Factory
    implements FlightClientMiddleware.Factory {
        private ConcurrentMap<String, HttpCookie> cookies = new ConcurrentHashMap<String, HttpCookie>();

        @Override
        public ClientCookieMiddleware onCallStarted(CallInfo info) {
            return new ClientCookieMiddleware(this);
        }

        private void updateCookies(Iterable<String> newCookieHeaderValues) {
            newCookieHeaderValues.forEach(headerValue -> {
                try {
                    List<HttpCookie> parsedCookies = HttpCookie.parse(headerValue);
                    parsedCookies.forEach(parsedCookie -> {
                        String cookieNameLc = parsedCookie.getName().toLowerCase(Locale.ENGLISH);
                        if (parsedCookie.hasExpired()) {
                            this.cookies.remove(cookieNameLc);
                        } else {
                            this.cookies.put(parsedCookie.getName().toLowerCase(Locale.ENGLISH), (HttpCookie)parsedCookie);
                        }
                    });
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn("Skipping incorrectly formatted Set-Cookie header with value '{}'.", headerValue);
                }
            });
        }
    }
}

