/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.numeric;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.function.IntSupplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.holders.NullableFloat4Holder;

public class ArrowFlightJdbcFloat4VectorAccessor
extends ArrowFlightJdbcAccessor {
    private final Float4Vector vector;
    private final NullableFloat4Holder holder = new NullableFloat4Holder();

    public ArrowFlightJdbcFloat4VectorAccessor(Float4Vector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.vector = vector;
    }

    @Override
    public Class<?> getObjectClass() {
        return Float.class;
    }

    @Override
    public String getString() {
        float value = this.getFloat();
        return this.wasNull ? null : Float.toString(value);
    }

    @Override
    public boolean getBoolean() {
        return (double)this.getFloat() != 0.0;
    }

    @Override
    public byte getByte() {
        return (byte)this.getFloat();
    }

    @Override
    public short getShort() {
        return (short)this.getFloat();
    }

    @Override
    public int getInt() {
        return (int)this.getFloat();
    }

    @Override
    public long getLong() {
        return (long)this.getFloat();
    }

    @Override
    public float getFloat() {
        this.vector.get(this.getCurrentRow(), this.holder);
        this.wasNull = this.holder.isSet == 0;
        this.wasNullConsumer.setWasNull(this.wasNull);
        if (this.wasNull) {
            return 0.0f;
        }
        return this.holder.value;
    }

    @Override
    public double getDouble() {
        return this.getFloat();
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        float value = this.getFloat();
        if (Float.isInfinite(value) || Float.isNaN(value)) {
            throw new SQLException("BigDecimal doesn't support Infinite/NaN.");
        }
        return this.wasNull ? null : BigDecimal.valueOf(value);
    }

    @Override
    public BigDecimal getBigDecimal(int scale) throws SQLException {
        float value = this.getFloat();
        if (Float.isInfinite(value) || Float.isNaN(value)) {
            throw new SQLException("BigDecimal doesn't support Infinite/NaN.");
        }
        return this.wasNull ? null : BigDecimal.valueOf(value).setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public Object getObject() {
        float value = this.getFloat();
        return this.wasNull ? null : Float.valueOf(value);
    }
}

