/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.base.Preconditions;

public class ConnectionWrapper
implements Connection {
    private final Connection realConnection;

    public ConnectionWrapper(Connection connection) {
        this.realConnection = Preconditions.checkNotNull(connection);
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return type.cast(this.realConnection);
    }

    @Override
    public boolean isWrapperFor(Class<?> type) {
        return this.realConnection.getClass().isAssignableFrom(type);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.realConnection.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sqlQuery) throws SQLException {
        return this.realConnection.prepareStatement(sqlQuery);
    }

    @Override
    public CallableStatement prepareCall(String sqlQuery) throws SQLException {
        return this.realConnection.prepareCall(sqlQuery);
    }

    @Override
    public String nativeSQL(String sqlStatement) throws SQLException {
        return this.realConnection.nativeSQL(sqlStatement);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.realConnection.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.realConnection.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.realConnection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.realConnection.rollback();
    }

    @Override
    public void close() throws SQLException {
        this.realConnection.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.realConnection.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.realConnection.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.realConnection.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.realConnection.isReadOnly();
    }

    @Override
    public void setCatalog(String catalogName) throws SQLException {
        this.realConnection.setCatalog(catalogName);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.realConnection.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int transactionIsolationId) throws SQLException {
        this.realConnection.setTransactionIsolation(transactionIsolationId);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.realConnection.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.realConnection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.realConnection.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetTypeId, int resultSetConcurrencyId) throws SQLException {
        return this.realConnection.createStatement(resultSetTypeId, resultSetConcurrencyId);
    }

    @Override
    public PreparedStatement prepareStatement(String sqlQuery, int resultSetTypeId, int resultSetConcurrencyId) throws SQLException {
        return this.realConnection.prepareStatement(sqlQuery, resultSetTypeId, resultSetConcurrencyId);
    }

    @Override
    public CallableStatement prepareCall(String query, int resultSetTypeId, int resultSetConcurrencyId) throws SQLException {
        return this.realConnection.prepareCall(query, resultSetTypeId, resultSetConcurrencyId);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.realConnection.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> typeNameToClass) throws SQLException {
        this.realConnection.setTypeMap(typeNameToClass);
    }

    @Override
    public void setHoldability(int holdabilityId) throws SQLException {
        this.realConnection.setHoldability(holdabilityId);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.realConnection.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.realConnection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String savepointName) throws SQLException {
        return this.realConnection.setSavepoint(savepointName);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.realConnection.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.realConnection.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.realConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sqlQuery, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.realConnection.prepareStatement(sqlQuery, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sqlQuery, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.realConnection.prepareCall(sqlQuery, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sqlQuery, int autoGeneratedKeysId) throws SQLException {
        return this.realConnection.prepareStatement(sqlQuery, autoGeneratedKeysId);
    }

    @Override
    public PreparedStatement prepareStatement(String sqlQuery, int[] columnIndices) throws SQLException {
        return this.realConnection.prepareStatement(sqlQuery, columnIndices);
    }

    @Override
    public PreparedStatement prepareStatement(String sqlQuery, String[] columnNames) throws SQLException {
        return this.realConnection.prepareStatement(sqlQuery, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.realConnection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.realConnection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.realConnection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.realConnection.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.realConnection.isValid(timeout);
    }

    @Override
    public void setClientInfo(String propertyName, String propertyValue) throws SQLClientInfoException {
        this.realConnection.setClientInfo(propertyName, propertyValue);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.realConnection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String propertyName) throws SQLException {
        return this.realConnection.getClientInfo(propertyName);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.realConnection.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.realConnection.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.realConnection.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schemaName) throws SQLException {
        this.realConnection.setSchema(schemaName);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.realConnection.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.realConnection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int timeoutInMillis) throws SQLException {
        this.realConnection.setNetworkTimeout(executor, timeoutInMillis);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.realConnection.getNetworkTimeout();
    }
}

