/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.operator.bc;

import java.io.IOException;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.ExtendedDigest;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.Signer;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.signers.RSADigestSigner;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.util.PublicKeyFactory;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.operator.OperatorCreationException;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcRSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new RSADigestSigner(extendedDigest);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

