/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1;

import java.io.IOException;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1ApplicationSpecificParser;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Exception;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1OutputStream;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Primitive;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1TaggedObjectParser;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.DERApplicationSpecific;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.DLApplicationSpecific;

public abstract class ASN1ApplicationSpecific
extends ASN1Primitive
implements ASN1ApplicationSpecificParser {
    final ASN1TaggedObject taggedObject;

    public static ASN1ApplicationSpecific getInstance(Object object) {
        if (object == null || object instanceof ASN1ApplicationSpecific) {
            return (ASN1ApplicationSpecific)object;
        }
        if (object instanceof byte[]) {
            try {
                return ASN1ApplicationSpecific.getInstance(ASN1Primitive.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to construct object from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    ASN1ApplicationSpecific(ASN1TaggedObject aSN1TaggedObject) {
        ASN1ApplicationSpecific.checkTagClass(aSN1TaggedObject.getTagClass());
        this.taggedObject = aSN1TaggedObject;
    }

    public int getApplicationTag() {
        return this.taggedObject.getTagNo();
    }

    public byte[] getContents() {
        return this.taggedObject.getContents();
    }

    public final ASN1Primitive getLoadedObject() {
        return this;
    }

    public ASN1Primitive getObject() throws IOException {
        return this.getEnclosedObject();
    }

    public ASN1Primitive getEnclosedObject() throws IOException {
        return this.taggedObject.getBaseObject().toASN1Primitive();
    }

    public ASN1Primitive getObject(int n) throws IOException {
        return this.taggedObject.getBaseUniversal(false, n);
    }

    public ASN1Encodable getObjectParser(int n, boolean bl) throws IOException {
        throw new ASN1Exception("this method only valid for CONTEXT_SPECIFIC tags");
    }

    public ASN1Encodable parseBaseUniversal(boolean bl, int n) throws IOException {
        return this.taggedObject.parseBaseUniversal(bl, n);
    }

    public ASN1Encodable parseExplicitBaseObject() throws IOException {
        return this.taggedObject.parseExplicitBaseObject();
    }

    public ASN1TaggedObjectParser parseExplicitBaseTagged() throws IOException {
        return this.taggedObject.parseExplicitBaseTagged();
    }

    public ASN1TaggedObjectParser parseImplicitBaseTagged(int n, int n2) throws IOException {
        return this.taggedObject.parseImplicitBaseTagged(n, n2);
    }

    public int getTagClass() {
        return 64;
    }

    public int getTagNo() {
        return this.taggedObject.getTagNo();
    }

    public boolean hasApplicationTag(int n) {
        return this.taggedObject.hasTag(64, n);
    }

    public boolean hasContextTag(int n) {
        return false;
    }

    public boolean hasTag(int n, int n2) {
        return this.taggedObject.hasTag(n, n2);
    }

    public ASN1TaggedObject getTaggedObject() {
        return this.taggedObject;
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        ASN1TaggedObject aSN1TaggedObject;
        if (aSN1Primitive instanceof ASN1ApplicationSpecific) {
            aSN1TaggedObject = ((ASN1ApplicationSpecific)aSN1Primitive).taggedObject;
        } else if (aSN1Primitive instanceof ASN1TaggedObject) {
            aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive;
        } else {
            return false;
        }
        return this.taggedObject.equals(aSN1TaggedObject);
    }

    public int hashCode() {
        return this.taggedObject.hashCode();
    }

    public boolean isConstructed() {
        return this.taggedObject.isConstructed();
    }

    public ASN1Encodable readObject() throws IOException {
        return this.parseExplicitBaseObject();
    }

    boolean encodeConstructed() {
        return this.taggedObject.encodeConstructed();
    }

    int encodedLength(boolean bl) throws IOException {
        return this.taggedObject.encodedLength(bl);
    }

    void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        this.taggedObject.encode(aSN1OutputStream, bl);
    }

    ASN1Primitive toDERObject() {
        return new DERApplicationSpecific((ASN1TaggedObject)this.taggedObject.toDERObject());
    }

    ASN1Primitive toDLObject() {
        return new DLApplicationSpecific((ASN1TaggedObject)this.taggedObject.toDLObject());
    }

    private static int checkTagClass(int n) {
        if (64 != n) {
            throw new IllegalArgumentException();
        }
        return n;
    }
}

