/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.util.hash;

import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.util.MemoryUtil;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.initialization.qual.Initialized;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.NonNull;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.dataflow.qual.Pure;

public class MurmurHasher
implements ArrowBufHasher {
    private final @UnknownKeyFor @NonNull @Initialized int seed;

    public MurmurHasher() {
        this(0);
    }

    public MurmurHasher(@UnknownKeyFor @NonNull @Initialized int seed) {
        this.seed = seed;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int hashCode(@UnknownKeyFor @NonNull @Initialized long address, @UnknownKeyFor @NonNull @Initialized long length) {
        return MurmurHasher.hashCode(address, length, this.seed);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int hashCode(@UnknownKeyFor @NonNull @Initialized ArrowBuf buf, @UnknownKeyFor @NonNull @Initialized long offset, @UnknownKeyFor @NonNull @Initialized long length) {
        buf.checkBytes(offset, offset + length);
        return this.hashCode(buf.memoryAddress() + offset, length);
    }

    public static @UnknownKeyFor @NonNull @Initialized int hashCode(@UnknownKeyFor @NonNull @Initialized ArrowBuf buf, @UnknownKeyFor @NonNull @Initialized long offset, @UnknownKeyFor @NonNull @Initialized long length, @UnknownKeyFor @NonNull @Initialized int seed) {
        buf.checkBytes(offset, offset + length);
        return MurmurHasher.hashCode(buf.memoryAddress() + offset, length, seed);
    }

    public static @UnknownKeyFor @NonNull @Initialized int hashCode(@UnknownKeyFor @NonNull @Initialized long address, @UnknownKeyFor @NonNull @Initialized long length, @UnknownKeyFor @NonNull @Initialized int seed) {
        int intValue;
        int index = 0;
        int hash = seed;
        while ((long)(index + 4) <= length) {
            intValue = MemoryUtil.UNSAFE.getInt(address + (long)index);
            hash = MurmurHasher.combineHashCode(hash, intValue);
            index += 4;
        }
        if ((long)index < length) {
            intValue = 0;
            for (long i = length - 1L; i >= (long)index; --i) {
                intValue <<= 8;
                intValue |= MemoryUtil.UNSAFE.getByte(address + i) & 0xFF;
                ++index;
            }
            hash = MurmurHasher.combineHashCode(hash, intValue);
        }
        return MurmurHasher.finalizeHashCode(hash, length);
    }

    public static @UnknownKeyFor @NonNull @Initialized int combineHashCode(@UnknownKeyFor @NonNull @Initialized int currentHashCode, @UnknownKeyFor @NonNull @Initialized int intValue) {
        int c1 = -862048943;
        int c2 = 461845907;
        int r1 = 15;
        int r2 = 13;
        int m = 5;
        int n = -430675100;
        int k = intValue;
        k *= c1;
        k = MurmurHasher.rotateLeft(k, r1);
        int hash = currentHashCode;
        hash ^= (k *= c2);
        hash = MurmurHasher.rotateLeft(hash, r2);
        hash = hash * m + n;
        return hash;
    }

    public static @UnknownKeyFor @NonNull @Initialized int finalizeHashCode(@UnknownKeyFor @NonNull @Initialized int hashCode, @UnknownKeyFor @NonNull @Initialized long length) {
        hashCode ^= (int)length;
        hashCode ^= hashCode >>> 16;
        hashCode *= -2048144789;
        hashCode ^= hashCode >>> 13;
        hashCode *= -1028477387;
        hashCode ^= hashCode >>> 16;
        return hashCode;
    }

    private static @UnknownKeyFor @NonNull @Initialized int rotateLeft(@UnknownKeyFor @NonNull @Initialized int value, @UnknownKeyFor @NonNull @Initialized int count) {
        return value << count | value >>> 32 - count;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MurmurHasher that = (MurmurHasher)o;
        return this.seed == that.seed;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.seed;
    }
}

