/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.util;

import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.util.ByteFunctionHelpers;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.util.hash.SimpleHasher;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.Preconditions;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.initialization.qual.Initialized;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.NonNull;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.dataflow.qual.Pure;

public final class ArrowBufPointer {
    public static final @UnknownKeyFor @NonNull @Initialized int NULL_HASH_CODE = 0;
    private @Nullable @UnknownKeyFor @Initialized ArrowBuf buf;
    private @UnknownKeyFor @NonNull @Initialized long offset;
    private @UnknownKeyFor @NonNull @Initialized long length;
    private @UnknownKeyFor @NonNull @Initialized int hashCode = 0;
    private final @UnknownKeyFor @NonNull @Initialized ArrowBufHasher hasher;
    private @UnknownKeyFor @NonNull @Initialized boolean hashCodeChanged = false;

    public ArrowBufPointer() {
        this(SimpleHasher.INSTANCE);
    }

    public ArrowBufPointer(@UnknownKeyFor @NonNull @Initialized ArrowBufHasher hasher) {
        Preconditions.checkNotNull(hasher);
        this.hasher = hasher;
        this.buf = null;
    }

    public ArrowBufPointer(@UnknownKeyFor @NonNull @Initialized ArrowBuf buf, @UnknownKeyFor @NonNull @Initialized long offset, @UnknownKeyFor @NonNull @Initialized long length) {
        this(buf, offset, length, SimpleHasher.INSTANCE);
    }

    public ArrowBufPointer(@UnknownKeyFor @NonNull @Initialized ArrowBuf buf, @UnknownKeyFor @NonNull @Initialized long offset, @UnknownKeyFor @NonNull @Initialized long length, @UnknownKeyFor @NonNull @Initialized ArrowBufHasher hasher) {
        Preconditions.checkNotNull(hasher);
        this.hasher = hasher;
        this.set(buf, offset, length);
    }

    public void set(@UnknownKeyFor @NonNull @Initialized ArrowBuf buf, @UnknownKeyFor @NonNull @Initialized long offset, @UnknownKeyFor @NonNull @Initialized long length) {
        this.buf = buf;
        this.offset = offset;
        this.length = length;
        this.hashCodeChanged = true;
    }

    public @Nullable @UnknownKeyFor @Initialized ArrowBuf getBuf() {
        return this.buf;
    }

    public @UnknownKeyFor @NonNull @Initialized long getOffset() {
        return this.offset;
    }

    public @UnknownKeyFor @NonNull @Initialized long getLength() {
        return this.length;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!this.hasher.equals(((ArrowBufPointer)o).hasher)) {
            return false;
        }
        ArrowBufPointer other = (ArrowBufPointer)o;
        if (this.buf == null || other.buf == null) {
            return this.buf == null && other.buf == null;
        }
        return ByteFunctionHelpers.equal(this.buf, this.offset, this.offset + this.length, other.buf, other.offset, other.offset + other.length) != 0;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        if (!this.hashCodeChanged) {
            return this.hashCode;
        }
        this.hashCode = this.buf == null ? 0 : this.hasher.hashCode(this.buf, this.offset, this.length);
        this.hashCodeChanged = false;
        return this.hashCode;
    }

    public @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized ArrowBufPointer that) {
        if (this.buf == null || that.buf == null) {
            if (this.buf == null && that.buf == null) {
                return 0;
            }
            return this.buf == null ? -1 : 1;
        }
        return ByteFunctionHelpers.compare(this.buf, this.offset, this.offset + this.length, that.buf, that.offset, that.offset + that.length);
    }
}

