/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.apache.arrow.driver.jdbc.shaded.com.google.protobuf.Timestamp;
import org.apache.arrow.driver.jdbc.shaded.com.google.protobuf.util.Timestamps;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.impl.Flight;

public class PollInfo {
    private final FlightInfo flightInfo;
    private final FlightDescriptor flightDescriptor;
    private final Double progress;
    private final Instant expirationTime;

    public PollInfo(FlightInfo flightInfo, FlightDescriptor flightDescriptor, Double progress, Instant expirationTime) {
        this.flightInfo = Objects.requireNonNull(flightInfo);
        this.flightDescriptor = flightDescriptor;
        this.progress = progress;
        this.expirationTime = expirationTime;
    }

    PollInfo(Flight.PollInfo flt) throws URISyntaxException {
        this.flightInfo = new FlightInfo(flt.getInfo());
        this.flightDescriptor = flt.hasFlightDescriptor() ? new FlightDescriptor(flt.getFlightDescriptor()) : null;
        this.progress = flt.hasProgress() ? Double.valueOf(flt.getProgress()) : null;
        this.expirationTime = flt.hasExpirationTime() ? Instant.ofEpochSecond(flt.getExpirationTime().getSeconds(), Timestamps.toNanos(flt.getExpirationTime())) : null;
    }

    public FlightInfo getFlightInfo() {
        return this.flightInfo;
    }

    public Optional<FlightDescriptor> getFlightDescriptor() {
        return Optional.ofNullable(this.flightDescriptor);
    }

    public Optional<Double> getProgress() {
        return Optional.ofNullable(this.progress);
    }

    public Optional<Instant> getExpirationTime() {
        return Optional.ofNullable(this.expirationTime);
    }

    Flight.PollInfo toProtocol() {
        Flight.PollInfo.Builder b = Flight.PollInfo.newBuilder();
        b.setInfo(this.flightInfo.toProtocol());
        if (this.flightDescriptor != null) {
            b.setFlightDescriptor(this.flightDescriptor.toProtocol());
        }
        if (this.progress != null) {
            b.setProgress(this.progress);
        }
        if (this.expirationTime != null) {
            b.setExpirationTime(Timestamp.newBuilder().setSeconds(this.expirationTime.getEpochSecond()).setNanos(this.expirationTime.getNano()).build());
        }
        return b.build();
    }

    public ByteBuffer serialize() {
        return ByteBuffer.wrap(this.toProtocol().toByteArray());
    }

    public static PollInfo deserialize(ByteBuffer serialized) throws IOException, URISyntaxException {
        return new PollInfo(Flight.PollInfo.parseFrom(serialized));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PollInfo)) {
            return false;
        }
        PollInfo pollInfo = (PollInfo)o;
        return Objects.equals(this.getFlightInfo(), pollInfo.getFlightInfo()) && Objects.equals(this.getFlightDescriptor(), pollInfo.getFlightDescriptor()) && Objects.equals(this.getProgress(), pollInfo.getProgress()) && Objects.equals(this.getExpirationTime(), pollInfo.getExpirationTime());
    }

    public int hashCode() {
        return Objects.hash(this.getFlightInfo(), this.getFlightDescriptor(), this.getProgress(), this.getExpirationTime());
    }

    public String toString() {
        return "PollInfo{flightInfo=" + this.flightInfo + ", flightDescriptor=" + this.flightDescriptor + ", progress=" + this.progress + ", expirationTime=" + this.expirationTime + '}';
    }
}

