/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.sql.example;

import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallOption;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightClient;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightStream;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.Location;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.sql.FlightSqlClient;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.sql.util.TableRef;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.driver.jdbc.shaded.org.apache.commons.cli.CommandLine;
import org.apache.arrow.driver.jdbc.shaded.org.apache.commons.cli.DefaultParser;
import org.apache.arrow.driver.jdbc.shaded.org.apache.commons.cli.HelpFormatter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.commons.cli.Options;
import org.apache.arrow.driver.jdbc.shaded.org.apache.commons.cli.ParseException;

public class FlightSqlClientDemoApp
implements AutoCloseable {
    public final List<CallOption> callOptions = new ArrayList<CallOption>();
    public final BufferAllocator allocator;
    public FlightSqlClient flightSqlClient;

    public FlightSqlClientDemoApp(BufferAllocator bufferAllocator) {
        this.allocator = bufferAllocator;
    }

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addRequiredOption("host", "host", true, "Host to connect to");
        options.addRequiredOption("port", "port", true, "Port to connect to");
        options.addRequiredOption("command", "command", true, "Method to run");
        options.addOption("query", "query", true, "Query");
        options.addOption("catalog", "catalog", true, "Catalog");
        options.addOption("schema", "schema", true, "Schema");
        options.addOption("table", "table", true, "Table");
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        try {
            CommandLine cmd = parser.parse(options, args);
            try (FlightSqlClientDemoApp thisApp = new FlightSqlClientDemoApp(new RootAllocator(Integer.MAX_VALUE));){
                thisApp.executeApp(cmd);
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp("FlightSqlClientDemoApp -host localhost -port 32010 ...", options);
            throw e;
        }
    }

    public CallOption[] getCallOptions() {
        return this.callOptions.toArray(new CallOption[0]);
    }

    public void executeApp(CommandLine cmd) throws Exception {
        String host = cmd.getOptionValue("host").trim();
        int port = Integer.parseInt(cmd.getOptionValue("port").trim());
        this.createFlightSqlClient(host, port);
        this.executeCommand(cmd);
    }

    public void executeCommand(CommandLine cmd) throws Exception {
        switch (cmd.getOptionValue("command").trim()) {
            case "Execute": {
                this.exampleExecute(cmd.getOptionValue("query"));
                break;
            }
            case "ExecuteUpdate": {
                this.exampleExecuteUpdate(cmd.getOptionValue("query"));
                break;
            }
            case "GetCatalogs": {
                this.exampleGetCatalogs();
                break;
            }
            case "GetSchemas": {
                this.exampleGetSchemas(cmd.getOptionValue("catalog"), cmd.getOptionValue("schema"));
                break;
            }
            case "GetTableTypes": {
                this.exampleGetTableTypes();
                break;
            }
            case "GetTables": {
                this.exampleGetTables(cmd.getOptionValue("catalog"), cmd.getOptionValue("schema"), cmd.getOptionValue("table"));
                break;
            }
            case "GetExportedKeys": {
                this.exampleGetExportedKeys(cmd.getOptionValue("catalog"), cmd.getOptionValue("schema"), cmd.getOptionValue("table"));
                break;
            }
            case "GetImportedKeys": {
                this.exampleGetImportedKeys(cmd.getOptionValue("catalog"), cmd.getOptionValue("schema"), cmd.getOptionValue("table"));
                break;
            }
            case "GetPrimaryKeys": {
                this.exampleGetPrimaryKeys(cmd.getOptionValue("catalog"), cmd.getOptionValue("schema"), cmd.getOptionValue("table"));
                break;
            }
            default: {
                System.out.println("Command used is not valid! Please use one of: \n[\"ExecuteUpdate\",\n\"Execute\",\n\"GetCatalogs\",\n\"GetSchemas\",\n\"GetTableTypes\",\n\"GetTables\",\n\"GetExportedKeys\",\n\"GetImportedKeys\",\n\"GetPrimaryKeys\"]");
            }
        }
    }

    public void createFlightSqlClient(String host, int port) {
        Location clientLocation = Location.forGrpcInsecure(host, port);
        this.flightSqlClient = new FlightSqlClient(FlightClient.builder(this.allocator, clientLocation).build());
    }

    private void exampleExecute(String query) throws Exception {
        this.printFlightInfoResults(this.flightSqlClient.execute(query, this.getCallOptions()));
    }

    private void exampleExecuteUpdate(String query) {
        System.out.println("Updated: " + this.flightSqlClient.executeUpdate(query, this.getCallOptions()) + "rows.");
    }

    private void exampleGetCatalogs() throws Exception {
        this.printFlightInfoResults(this.flightSqlClient.getCatalogs(this.getCallOptions()));
    }

    private void exampleGetSchemas(String catalog, String schema) throws Exception {
        this.printFlightInfoResults(this.flightSqlClient.getSchemas(catalog, schema, this.getCallOptions()));
    }

    private void exampleGetTableTypes() throws Exception {
        this.printFlightInfoResults(this.flightSqlClient.getTableTypes(this.getCallOptions()));
    }

    private void exampleGetTables(String catalog, String schema, String table) throws Exception {
        this.printFlightInfoResults(this.flightSqlClient.getTables(catalog, schema, table, null, false, this.getCallOptions()));
    }

    private void exampleGetExportedKeys(String catalog, String schema, String table) throws Exception {
        this.printFlightInfoResults(this.flightSqlClient.getExportedKeys(TableRef.of(catalog, schema, table), this.getCallOptions()));
    }

    private void exampleGetImportedKeys(String catalog, String schema, String table) throws Exception {
        this.printFlightInfoResults(this.flightSqlClient.getImportedKeys(TableRef.of(catalog, schema, table), this.getCallOptions()));
    }

    private void exampleGetPrimaryKeys(String catalog, String schema, String table) throws Exception {
        this.printFlightInfoResults(this.flightSqlClient.getPrimaryKeys(TableRef.of(catalog, schema, table), this.getCallOptions()));
    }

    private void printFlightInfoResults(FlightInfo flightInfo) throws Exception {
        FlightStream stream = this.flightSqlClient.getStream(flightInfo.getEndpoints().get(0).getTicket(), this.getCallOptions());
        while (stream.next()) {
            VectorSchemaRoot root = stream.getRoot();
            Throwable throwable = null;
            try {
                System.out.println(root.contentToTSVString());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (root == null) continue;
                FlightSqlClientDemoApp.$closeResource(throwable, root);
            }
        }
        stream.close();
    }

    @Override
    public void close() throws Exception {
        this.flightSqlClient.close();
        this.allocator.close();
    }
}

