/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.util.concurrent.SettableFuture;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.stub.StreamObserver;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.ArrowMessage;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallStatus;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.grpc.StatusUtils;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.VisibleForTesting;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.MetadataVersion;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.util.DictionaryUtility;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.validate.MetadataV4UnionChecker;

public class FlightStream
implements AutoCloseable {
    private final AutoCloseable DONE = new AutoCloseable(){

        @Override
        public void close() throws Exception {
        }
    };
    private final AutoCloseable DONE_EX = new AutoCloseable(){

        @Override
        public void close() throws Exception {
        }
    };
    private final BufferAllocator allocator;
    private final Cancellable cancellable;
    private final LinkedBlockingQueue<AutoCloseable> queue = new LinkedBlockingQueue();
    private final SettableFuture<VectorSchemaRoot> root = SettableFuture.create();
    private final SettableFuture<FlightDescriptor> descriptor = SettableFuture.create();
    private final int pendingTarget;
    private final Requestor requestor;
    final CompletableFuture<Void> completed;
    final CompletableFuture<Void> cancelled;
    private final AtomicInteger pending = new AtomicInteger();
    private volatile VectorSchemaRoot fulfilledRoot;
    private DictionaryProvider.MapDictionaryProvider dictionaries;
    private volatile VectorLoader loader;
    private volatile Throwable ex;
    private volatile ArrowBuf applicationMetadata = null;
    @VisibleForTesting
    volatile MetadataVersion metadataVersion = null;

    public FlightStream(BufferAllocator allocator, int pendingTarget, Cancellable cancellable, Requestor requestor) {
        Objects.requireNonNull(allocator);
        Objects.requireNonNull(requestor);
        this.allocator = allocator;
        this.pendingTarget = pendingTarget;
        this.cancellable = cancellable;
        this.requestor = requestor;
        this.dictionaries = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        this.completed = new CompletableFuture();
        this.cancelled = new CompletableFuture();
    }

    public Schema getSchema() {
        return this.getRoot().getSchema();
    }

    public DictionaryProvider getDictionaryProvider() {
        if (this.dictionaries == null) {
            throw new IllegalStateException("Dictionary ownership was claimed by the application.");
        }
        return this.dictionaries;
    }

    public DictionaryProvider takeDictionaryOwnership() {
        if (this.dictionaries == null) {
            throw new IllegalStateException("Dictionary ownership was claimed by the application.");
        }
        DictionaryProvider.MapDictionaryProvider provider = this.dictionaries;
        this.dictionaries = null;
        return provider;
    }

    public FlightDescriptor getDescriptor() {
        try {
            return (FlightDescriptor)this.descriptor.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw CallStatus.INTERNAL.withCause(e).withDescription("Interrupted").toRuntimeException();
        }
        catch (ExecutionException e) {
            throw CallStatus.INTERNAL.withCause(e).withDescription("Error getting descriptor").toRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object;
        ArrayList<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
        FlightRuntimeException suppressor = null;
        if (this.cancellable != null) {
            try {
                object = this.cancellable;
                synchronized (object) {
                    if (!this.cancelled.isDone()) {
                        this.cancellable.cancel("Stream closed before end", null);
                    }
                }
                while (this.next()) {
                }
            }
            catch (FlightRuntimeException e) {
                suppressor = e;
            }
        }
        object = this.completed;
        synchronized (object) {
            try {
                if (this.fulfilledRoot != null) {
                    closeables.add(this.fulfilledRoot);
                }
                closeables.add(this.applicationMetadata);
                closeables.addAll(this.queue);
                if (this.dictionaries != null) {
                    this.dictionaries.getDictionaryIds().forEach(id -> closeables.add(this.dictionaries.lookup((long)id).getVector()));
                }
                if (suppressor != null) {
                    AutoCloseables.close((Throwable)suppressor, closeables);
                } else {
                    AutoCloseables.close(closeables);
                }
                this.applicationMetadata = null;
            }
            finally {
                this.completed.complete(null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean next() {
        try {
            if (this.completed.isDone() && this.queue.isEmpty()) {
                return false;
            }
            this.pending.decrementAndGet();
            this.requestOutstanding();
            AutoCloseable data = this.queue.take();
            if (this.DONE == data) {
                this.queue.put(this.DONE);
                this.completed.complete(null);
                return false;
            }
            if (this.DONE_EX == data) {
                this.queue.put(this.DONE_EX);
                if (!(this.ex instanceof Exception)) throw new Exception(this.ex);
                throw (Exception)this.ex;
            }
            try (ArrowMessage msg = (ArrowMessage)data;){
                if (msg.getMessageType() == ArrowMessage.HeaderType.NONE) {
                    this.updateMetadata(msg);
                    if (this.fulfilledRoot != null) {
                        this.fulfilledRoot.clear();
                    }
                } else if (msg.getMessageType() == ArrowMessage.HeaderType.RECORD_BATCH) {
                    this.checkMetadataVersion(msg);
                    ((VectorSchemaRoot)this.root.get()).clear();
                    try (ArrowRecordBatch arb = msg.asRecordBatch();){
                        this.loader.load(arb);
                    }
                    this.updateMetadata(msg);
                } else {
                    if (msg.getMessageType() != ArrowMessage.HeaderType.DICTIONARY_BATCH) throw new UnsupportedOperationException("Message type is unsupported: " + (Object)((Object)msg.getMessageType()));
                    this.checkMetadataVersion(msg);
                    ((VectorSchemaRoot)this.root.get()).clear();
                    try (ArrowDictionaryBatch arb = msg.asDictionaryBatch();){
                        long id = arb.getDictionaryId();
                        if (this.dictionaries == null) {
                            throw new IllegalStateException("Dictionary ownership was claimed by the application.");
                        }
                        Dictionary dictionary = this.dictionaries.lookup(id);
                        if (dictionary == null) {
                            throw new IllegalArgumentException("Dictionary not defined in schema: ID " + id);
                        }
                        FieldVector vector = dictionary.getVector();
                        VectorSchemaRoot dictionaryRoot = new VectorSchemaRoot(Collections.singletonList(vector.getField()), Collections.singletonList(vector), 0);
                        VectorLoader dictionaryLoader = new VectorLoader(dictionaryRoot);
                        dictionaryLoader.load(arb.getDictionary());
                    }
                    boolean bl = this.next();
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw StatusUtils.fromThrowable(e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updateMetadata(ArrowMessage msg) {
        if (this.applicationMetadata != null) {
            this.applicationMetadata.close();
        }
        this.applicationMetadata = msg.getApplicationMetadata();
        if (this.applicationMetadata != null) {
            this.applicationMetadata.getReferenceManager().retain();
        }
    }

    private void checkMetadataVersion(ArrowMessage msg) {
        if (msg.asSchemaMessage() == null) {
            return;
        }
        MetadataVersion receivedVersion = MetadataVersion.fromFlatbufID(msg.asSchemaMessage().getMessage().version());
        if (this.metadataVersion != receivedVersion) {
            throw new IllegalStateException("Metadata version mismatch: stream started as " + (Object)((Object)this.metadataVersion) + " but got message with version " + (Object)((Object)receivedVersion));
        }
    }

    public VectorSchemaRoot getRoot() {
        try {
            return (VectorSchemaRoot)this.root.get();
        }
        catch (InterruptedException e) {
            throw CallStatus.INTERNAL.withCause(e).toRuntimeException();
        }
        catch (ExecutionException e) {
            throw StatusUtils.fromThrowable(e.getCause());
        }
    }

    public boolean hasRoot() {
        return this.root.isDone();
    }

    public ArrowBuf getLatestMetadata() {
        return this.applicationMetadata;
    }

    private synchronized void requestOutstanding() {
        if (this.pending.get() < this.pendingTarget) {
            this.requestor.request(this.pendingTarget - this.pending.get());
            this.pending.set(this.pendingTarget);
        }
    }

    public void cancel(String message, Throwable exception) {
        if (this.cancellable == null) {
            throw new UnsupportedOperationException("Streams cannot be cancelled that are produced by client. Instead, server should reject incoming messages.");
        }
        this.cancellable.cancel(message, exception);
    }

    StreamObserver<ArrowMessage> asObserver() {
        return new Observer();
    }

    @FunctionalInterface
    public static interface Requestor {
        public void request(int var1);
    }

    @FunctionalInterface
    public static interface Cancellable {
        public void cancel(String var1, Throwable var2);
    }

    private class Observer
    implements StreamObserver<ArrowMessage> {
        Observer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enqueue(AutoCloseable message) {
            CompletableFuture<Void> completableFuture = FlightStream.this.completed;
            synchronized (completableFuture) {
                if (FlightStream.this.completed.isDone()) {
                    AutoCloseables.closeNoChecked(message);
                } else {
                    FlightStream.this.queue.add(message);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(ArrowMessage msg) {
            FlightStream.this.requestOutstanding();
            switch (msg.getMessageType()) {
                case NONE: {
                    if (msg.getDescriptor() != null) {
                        FlightStream.this.descriptor.set(new FlightDescriptor(msg.getDescriptor()));
                    }
                    if (msg.getApplicationMetadata() == null) break;
                    this.enqueue(msg);
                    break;
                }
                case SCHEMA: {
                    Schema schema = msg.asSchema();
                    ArrowBuf meta = msg.getApplicationMetadata();
                    if (meta != null) {
                        meta.close();
                    }
                    ArrayList<Field> fields = new ArrayList<Field>();
                    HashMap<Long, Dictionary> dictionaryMap = new HashMap<Long, Dictionary>();
                    for (Field field : schema.getFields()) {
                        Field updatedField = DictionaryUtility.toMemoryFormat(field, FlightStream.this.allocator, dictionaryMap);
                        fields.add(updatedField);
                    }
                    for (Map.Entry entry : dictionaryMap.entrySet()) {
                        FlightStream.this.dictionaries.put((Dictionary)entry.getValue());
                    }
                    schema = new Schema(fields, schema.getCustomMetadata());
                    FlightStream.this.metadataVersion = MetadataVersion.fromFlatbufID(msg.asSchemaMessage().getMessage().version());
                    try {
                        MetadataV4UnionChecker.checkRead(schema, FlightStream.this.metadataVersion);
                    }
                    catch (IOException e) {
                        FlightStream.this.ex = e;
                        this.enqueue(FlightStream.this.DONE_EX);
                        break;
                    }
                    CompletableFuture<Void> completableFuture = FlightStream.this.completed;
                    synchronized (completableFuture) {
                        if (!FlightStream.this.completed.isDone()) {
                            FlightStream.this.fulfilledRoot = VectorSchemaRoot.create(schema, FlightStream.this.allocator);
                            FlightStream.this.loader = new VectorLoader(FlightStream.this.fulfilledRoot);
                            if (msg.getDescriptor() != null) {
                                FlightStream.this.descriptor.set(new FlightDescriptor(msg.getDescriptor()));
                            }
                            FlightStream.this.root.set(FlightStream.this.fulfilledRoot);
                        }
                        break;
                    }
                }
                case RECORD_BATCH: 
                case DICTIONARY_BATCH: {
                    this.enqueue(msg);
                    break;
                }
                default: {
                    FlightStream.this.ex = new UnsupportedOperationException("Unable to handle message of type: " + (Object)((Object)msg.getMessageType()));
                    this.enqueue(FlightStream.this.DONE_EX);
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            FlightStream.this.ex = StatusUtils.fromThrowable(t);
            FlightStream.this.queue.add(FlightStream.this.DONE_EX);
            FlightStream.this.cancelled.complete(null);
            FlightStream.this.root.setException(FlightStream.this.ex);
        }

        @Override
        public void onCompleted() {
            FlightStream.this.cancelled.complete(null);
            FlightStream.this.queue.add(FlightStream.this.DONE);
        }
    }
}

