/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.apache.arrow.driver.jdbc.ArrowFlightConnection;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcFactory;
import org.apache.arrow.driver.jdbc.ArrowFlightMetaImpl;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.Preconditions;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.VisibleForTesting;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.DriverVersion;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.arrow.driver.jdbc.utils.ArrowFlightConnectionConfigImpl;
import org.apache.arrow.driver.jdbc.utils.UrlParser;

public class ArrowFlightJdbcDriver
extends UnregisteredDriver {
    private static final String CONNECT_STRING_PREFIX = "jdbc:arrow-flight-sql://";
    private static final String CONNECT_STRING_PREFIX_DEPRECATED = "jdbc:arrow-flight://";
    private static final String CONNECTION_STRING_EXPECTED = "jdbc:arrow-flight-sql://[host][:port][?param1=value&...]";
    private static DriverVersion version;

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger(this.getClass().getPackage().getName());
    }

    @Override
    public ArrowFlightConnection connect(String url, Properties info) throws SQLException {
        Properties properties = new Properties(info);
        properties.putAll((Map<?, ?>)info);
        if (url != null) {
            Optional<Map<Object, Object>> maybeProperties = this.getUrlsArgs(url);
            if (!maybeProperties.isPresent()) {
                return null;
            }
            Map<Object, Object> propertiesFromUrl = maybeProperties.get();
            properties.putAll(propertiesFromUrl);
        }
        try {
            return ArrowFlightConnection.createNewConnection(this, this.factory, url, ArrowFlightJdbcDriver.lowerCasePropertyKeys(properties), new RootAllocator(Long.MAX_VALUE));
        }
        catch (FlightRuntimeException e) {
            throw new SQLException("Failed to connect.", e);
        }
    }

    @Override
    protected String getFactoryClassName(UnregisteredDriver.JdbcVersion jdbcVersion) {
        return ArrowFlightJdbcFactory.class.getName();
    }

    @Override
    protected DriverVersion createDriverVersion() {
        if (version == null) {
            InputStream flightProperties = this.getClass().getResourceAsStream("/properties/flight.properties");
            if (flightProperties == null) {
                throw new RuntimeException("Flight Properties not found. Ensure the JAR was built properly.");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(flightProperties, StandardCharsets.UTF_8));){
                Properties properties = new Properties();
                properties.load(reader);
                String parentName = properties.getProperty("org.apache.arrow.flight.name");
                String parentVersion = properties.getProperty("org.apache.arrow.flight.version");
                String[] pVersion = parentVersion.split("\\.");
                int parentMajorVersion = Integer.parseInt(pVersion[0]);
                int parentMinorVersion = Integer.parseInt(pVersion[1]);
                String childName = properties.getProperty("org.apache.arrow.flight.jdbc-driver.name");
                String childVersion = properties.getProperty("org.apache.arrow.flight.jdbc-driver.version");
                String[] cVersion = childVersion.split("\\.");
                int childMajorVersion = Integer.parseInt(cVersion[0]);
                int childMinorVersion = Integer.parseInt(cVersion[1]);
                version = new DriverVersion(childName, childVersion, parentName, parentVersion, true, childMajorVersion, childMinorVersion, parentMajorVersion, parentMinorVersion);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load driver version.", e);
            }
        }
        return version;
    }

    @Override
    public Meta createMeta(AvaticaConnection connection) {
        return new ArrowFlightMetaImpl(connection);
    }

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    public boolean acceptsURL(String url) {
        Preconditions.checkNotNull(url);
        return url.startsWith(CONNECT_STRING_PREFIX) || url.startsWith(CONNECT_STRING_PREFIX_DEPRECATED);
    }

    @VisibleForTesting
    Optional<Map<Object, Object>> getUrlsArgs(String url) throws SQLException {
        URI uri;
        Properties resultMap = new Properties();
        if (!(url = ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.replaceSemiColons(url)).startsWith("jdbc:")) {
            throw new SQLException("Connection string must start with 'jdbc:'. Expected format: jdbc:arrow-flight-sql://[host][:port][?param1=value&...]");
        }
        url = url.substring(5);
        try {
            uri = URI.create(url);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Malformed/invalid URL!", e);
        }
        if (!Objects.equals(uri.getScheme(), "arrow-flight") && !Objects.equals(uri.getScheme(), "arrow-flight-sql")) {
            return Optional.empty();
        }
        if (uri.getHost() == null) {
            throw new SQLException("URL must have a host. Expected format: jdbc:arrow-flight-sql://[host][:port][?param1=value&...]");
        }
        if (uri.getPort() < 0) {
            throw new SQLException("URL must have a port. Expected format: jdbc:arrow-flight-sql://[host][:port][?param1=value&...]");
        }
        resultMap.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST.camelName(), uri.getHost());
        resultMap.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT.camelName(), (Object)uri.getPort());
        String extraParams = uri.getRawQuery();
        if (extraParams != null) {
            Map<String, String> keyValuePairs = UrlParser.parse(extraParams, "&");
            resultMap.putAll(keyValuePairs);
        }
        return Optional.of(resultMap);
    }

    static Properties lowerCasePropertyKeys(Properties properties) {
        Properties resultProperty = new Properties();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> resultProperty.put(k.toString().toLowerCase(), v)));
        return resultProperty;
    }

    static {
        String key = "org.apache.arrow.driver.jdbc.shaded.io.netty.tryReflectionSetAccessible";
        String tryReflectionSetAccessible = System.getProperty("org.apache.arrow.driver.jdbc.shaded.io.netty.tryReflectionSetAccessible");
        if (tryReflectionSetAccessible == null) {
            System.setProperty("org.apache.arrow.driver.jdbc.shaded.io.netty.tryReflectionSetAccessible", Boolean.TRUE.toString());
        }
        new ArrowFlightJdbcDriver().register();
    }
}

