/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightRuntimeException;

final class IntegrationAssertions {
    IntegrationAssertions() {
    }

    static <T extends Throwable> T assertThrows(Class<T> clazz, AssertThrows body) {
        try {
            body.run();
        }
        catch (Throwable t) {
            if (clazz.isInstance(t)) {
                return (T)t;
            }
            throw new AssertionError("Expected exception of class " + clazz + " but got " + t.getClass(), t);
        }
        throw new AssertionError((Object)("Expected exception of class " + clazz + " but did not throw."));
    }

    static void assertEquals(Object expected, Object actual) {
        if (!Objects.equals(expected, actual)) {
            throw new AssertionError((Object)("Expected:\n" + expected + "\nbut got:\n" + actual));
        }
    }

    static void assertFalse(String message, boolean value) {
        if (value) {
            throw new AssertionError((Object)("Expected false: " + message));
        }
    }

    static void assertTrue(String message, boolean value) {
        if (!value) {
            throw new AssertionError((Object)("Expected true: " + message));
        }
    }

    static FlightRuntimeException toFlightRuntimeException(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return CallStatus.UNKNOWN.withCause(t).withDescription("Unknown error: " + t + "\n. Stack trace:\n" + stringWriter.toString()).toRuntimeException();
    }

    @FunctionalInterface
    static interface AssertThrows {
        public void run() throws Throwable;
    }
}

