/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.example.InMemoryStore;
import org.apache.arrow.flight.integration.tests.Scenario;
import org.apache.arrow.flight.integration.tests.Scenarios;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntegrationTestServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrationTestServer.class);
    private final Options options = new Options();

    private IntegrationTestServer() {
        this.options.addOption("port", true, "The port to serve on.");
        this.options.addOption("scenario", true, "The integration test scenario.");
    }

    private void run(String[] args) throws Exception {
        FlightServer server;
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(this.options, args, false);
        int port = Integer.parseInt(cmd.getOptionValue("port", "31337"));
        Location location = Location.forGrpcInsecure((String)"localhost", (int)port);
        RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
        FlightServer.Builder builder = FlightServer.builder().allocator((BufferAllocator)allocator).location(location);
        if (cmd.hasOption("scenario")) {
            Scenario scenario = Scenarios.getScenario(cmd.getOptionValue("scenario"));
            scenario.buildServer(builder);
            server = builder.producer(scenario.producer((BufferAllocator)allocator, location)).build();
            server.start();
        } else {
            InMemoryStore store = new InMemoryStore((BufferAllocator)allocator, location);
            server = FlightServer.builder((BufferAllocator)allocator, (Location)location, (FlightProducer)store).build().start();
            store.setLocation(Location.forGrpcInsecure((String)"localhost", (int)server.getPort()));
        }
        System.out.println("Server listening on localhost:" + server.getPort());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> IntegrationTestServer.lambda$run$0(server, (BufferAllocator)allocator)));
        server.awaitTermination();
    }

    public static void main(String[] args) {
        try {
            new IntegrationTestServer().run(args);
        }
        catch (ParseException e) {
            IntegrationTestServer.fatalError("Error parsing arguments", e);
        }
        catch (Exception e) {
            IntegrationTestServer.fatalError("Runtime error", e);
        }
    }

    private static void fatalError(String message, Throwable e) {
        System.err.println(message);
        System.err.println(e.getMessage());
        LOGGER.error(message, e);
        System.exit(1);
    }

    private static /* synthetic */ void lambda$run$0(FlightServer server, BufferAllocator allocator) {
        try {
            System.out.println("\nExiting...");
            AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{server, allocator});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

