/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.integration.tests.Scenario;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;

final class AppMetadataFlightInfoEndpointScenario
implements Scenario {
    AppMetadataFlightInfoEndpointScenario() {
    }

    @Override
    public FlightProducer producer(BufferAllocator allocator, Location location) throws Exception {
        return new AppMetadataFlightInfoEndpointProducer();
    }

    @Override
    public void buildServer(FlightServer.Builder builder) throws Exception {
    }

    @Override
    public void client(BufferAllocator allocator, Location location, FlightClient client) throws Exception {
        byte[] cmd = "foobar".getBytes(StandardCharsets.UTF_8);
        FlightInfo info = client.getInfo(FlightDescriptor.command((byte[])cmd), new CallOption[0]);
        IntegrationAssertions.assertEquals(info.getAppMetadata(), cmd);
        IntegrationAssertions.assertEquals(info.getEndpoints().size(), 1);
        IntegrationAssertions.assertEquals(((FlightEndpoint)info.getEndpoints().get(0)).getAppMetadata(), cmd);
    }

    static class AppMetadataFlightInfoEndpointProducer
    extends NoOpFlightProducer {
        AppMetadataFlightInfoEndpointProducer() {
        }

        public FlightInfo getFlightInfo(FlightProducer.CallContext context, FlightDescriptor descriptor) {
            byte[] cmd = descriptor.getCommand();
            Schema schema = new Schema(Collections.singletonList(Field.notNullable((String)"number", (ArrowType)Types.MinorType.UINT4.getType())));
            List<FlightEndpoint> endpoints = Collections.singletonList(FlightEndpoint.builder((Ticket)new Ticket("".getBytes(StandardCharsets.UTF_8)), (Location[])new Location[0]).setAppMetadata(cmd).build());
            return FlightInfo.builder((Schema)schema, (FlightDescriptor)descriptor, endpoints).setAppMetadata(cmd).build();
        }
    }
}

