/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.PollInfo;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;

class PollFlightInfoProducer
extends NoOpFlightProducer {
    static final byte[] POLL_DESCRIPTOR = "poll".getBytes(StandardCharsets.UTF_8);

    PollFlightInfoProducer() {
    }

    public PollInfo pollFlightInfo(FlightProducer.CallContext context, FlightDescriptor descriptor) {
        Schema schema = new Schema(Collections.singletonList(Field.notNullable((String)"number", (ArrowType)Types.MinorType.UINT4.getType())));
        List<FlightEndpoint> endpoints = Collections.singletonList(new FlightEndpoint(new Ticket("long-running query".getBytes(StandardCharsets.UTF_8)), new Location[0]));
        FlightInfo info = new FlightInfo(schema, descriptor, endpoints, -1L, -1L);
        if (descriptor.isCommand() && Arrays.equals(descriptor.getCommand(), POLL_DESCRIPTOR)) {
            return new PollInfo(info, null, Double.valueOf(1.0), null);
        }
        return new PollInfo(info, FlightDescriptor.command((byte[])POLL_DESCRIPTOR), Double.valueOf(0.1), Instant.now().plus(10L, ChronoUnit.SECONDS));
    }
}

