/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.tools;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.schema.ArrowRecordBatch;
import org.apache.arrow.vector.stream.ArrowStreamReader;
import org.apache.arrow.vector.stream.ArrowStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EchoServer.class);
    private boolean closed = false;
    private final ServerSocket serverSocket;

    public EchoServer(int port) throws IOException {
        LOGGER.info("Starting echo server.");
        this.serverSocket = new ServerSocket(port);
        LOGGER.info("Running echo server on port: " + this.port());
    }

    public int port() {
        return this.serverSocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        try {
            while (!this.closed) {
                LOGGER.info("Waiting to accept new client connection.");
                Socket clientSocket = this.serverSocket.accept();
                LOGGER.info("Accepted new client connection.");
                try (ClientConnection client = new ClientConnection(clientSocket);){
                    try {
                        client.run();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Error handling client connection.", (Throwable)e);
                    }
                }
                LOGGER.info("Closed connection with client");
            }
        }
        catch (SocketException ex) {
            if (!this.closed) {
                throw ex;
            }
        }
        finally {
            this.serverSocket.close();
            LOGGER.info("Server closed.");
        }
    }

    public void close() throws IOException {
        this.closed = true;
        this.serverSocket.close();
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8080;
        new EchoServer(port).run();
    }

    public static class ClientConnection
    implements AutoCloseable {
        public final Socket socket;

        public ClientConnection(Socket socket) {
            this.socket = socket;
        }

        public void run() throws IOException {
            RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
            ArrayList<ArrowRecordBatch> batches = new ArrayList<ArrowRecordBatch>();
            try (InputStream in = this.socket.getInputStream();
                 OutputStream out = this.socket.getOutputStream();
                 ArrowStreamReader reader = new ArrowStreamReader(in, (BufferAllocator)allocator);){
                ArrowRecordBatch batch;
                reader.init();
                while ((batch = reader.nextRecordBatch()) != null) {
                    batches.add(batch);
                }
                LOGGER.info(String.format("Received %d batches", batches.size()));
                try (ArrowStreamWriter writer = new ArrowStreamWriter(out, reader.getSchema());){
                    for (ArrowRecordBatch batch2 : batches) {
                        writer.writeRecordBatch(batch2);
                    }
                    writer.end();
                    Preconditions.checkState((reader.bytesRead() == writer.bytesWritten() ? 1 : 0) != 0);
                }
                LOGGER.info("Done writing stream back.");
            }
        }

        @Override
        public void close() throws IOException {
            this.socket.close();
        }
    }
}

