/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.ipc.JsonFileReader;
import org.apache.arrow.vector.ipc.JsonFileWriter;
import org.apache.arrow.vector.ipc.message.ArrowBlock;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Validator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Integration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Integration.class);
    private final Options options = new Options();

    Integration() {
        this.options.addOption("a", "arrow", true, "arrow file");
        this.options.addOption("j", "json", true, "json file");
        this.options.addOption("c", "command", true, "command to execute: " + Arrays.toString((Object[])Command.values()));
    }

    public static void main(String[] args) {
        try {
            new Integration().run(args);
        }
        catch (ParseException e) {
            Integration.fatalError("Invalid parameters", e);
        }
        catch (IOException e) {
            Integration.fatalError("Error accessing files", e);
        }
        catch (RuntimeException e) {
            Integration.fatalError("Incompatible files", e);
        }
    }

    private static void fatalError(String message, Throwable e) {
        System.err.println(message);
        System.err.println(e.getMessage());
        LOGGER.error(message, e);
        System.exit(1);
    }

    private File validateFile(String type, String fileName, boolean shouldExist) {
        if (fileName == null) {
            throw new IllegalArgumentException("missing " + type + " file parameter");
        }
        File f = new File(fileName);
        if (shouldExist && (!f.exists() || f.isDirectory())) {
            throw new IllegalArgumentException(type + " file not found: " + f.getAbsolutePath());
        }
        if (!shouldExist && f.exists()) {
            throw new IllegalArgumentException(type + " file already exists: " + f.getAbsolutePath());
        }
        return f;
    }

    static void extractDictionaryEncodings(List<Field> fields, List<DictionaryEncoding> encodings) {
        for (Field field : fields) {
            DictionaryEncoding encoding = field.getDictionary();
            if (encoding != null) {
                encodings.add(encoding);
            }
            Integration.extractDictionaryEncodings(field.getChildren(), encodings);
        }
    }

    void run(String[] args) throws ParseException, IOException {
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.options, args, false);
        Command command = this.toCommand(cmd.getOptionValue("command"));
        File arrowFile = this.validateFile("arrow", cmd.getOptionValue("arrow"), command.arrowExists);
        File jsonFile = this.validateFile("json", cmd.getOptionValue("json"), command.jsonExists);
        command.execute(arrowFile, jsonFile);
    }

    private Command toCommand(String commandName) {
        try {
            return Command.valueOf(commandName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown command: " + commandName + " expected one of " + Arrays.toString((Object[])Command.values()));
        }
    }

    static enum Command {
        ARROW_TO_JSON(true, false){

            @Override
            public void execute(File arrowFile, File jsonFile) throws IOException {
                try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
                     FileInputStream fileInputStream = new FileInputStream(arrowFile);
                     ArrowFileReader arrowReader = new ArrowFileReader((SeekableByteChannel)fileInputStream.getChannel(), (BufferAllocator)allocator);){
                    VectorSchemaRoot root = arrowReader.getVectorSchemaRoot();
                    Schema schema = root.getSchema();
                    LOGGER.debug("Input file size: " + arrowFile.length());
                    LOGGER.debug("Found schema: " + schema);
                    try (JsonFileWriter writer = new JsonFileWriter(jsonFile, JsonFileWriter.config().pretty(true));){
                        writer.start(schema, (DictionaryProvider)arrowReader);
                        for (ArrowBlock rbBlock : arrowReader.getRecordBlocks()) {
                            if (!arrowReader.loadRecordBatch(rbBlock)) {
                                throw new IOException("Expected to load record batch");
                            }
                            writer.write(root);
                        }
                    }
                    LOGGER.debug("Output file size: " + jsonFile.length());
                }
            }
        }
        ,
        JSON_TO_ARROW(false, true){

            @Override
            public void execute(File arrowFile, File jsonFile) throws IOException {
                try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
                     JsonFileReader reader = new JsonFileReader(jsonFile, (BufferAllocator)allocator);){
                    Schema schema = reader.start();
                    LOGGER.debug("Input file size: " + jsonFile.length());
                    LOGGER.debug("Found schema: " + schema);
                    try (FileOutputStream fileOutputStream = new FileOutputStream(arrowFile);
                         VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);
                         ArrowFileWriter arrowWriter = new ArrowFileWriter(root, (DictionaryProvider)reader, (WritableByteChannel)fileOutputStream.getChannel());){
                        arrowWriter.start();
                        while (reader.read(root)) {
                            arrowWriter.writeBatch();
                        }
                        arrowWriter.end();
                    }
                    LOGGER.debug("Output file size: " + arrowFile.length());
                }
            }
        }
        ,
        VALIDATE(true, true){

            @Override
            public void execute(File arrowFile, File jsonFile) throws IOException {
                try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
                     JsonFileReader jsonReader = new JsonFileReader(jsonFile, (BufferAllocator)allocator);
                     FileInputStream fileInputStream = new FileInputStream(arrowFile);
                     ArrowFileReader arrowReader = new ArrowFileReader((SeekableByteChannel)fileInputStream.getChannel(), (BufferAllocator)allocator);){
                    VectorSchemaRoot jsonRoot;
                    Schema jsonSchema = jsonReader.start();
                    VectorSchemaRoot arrowRoot = arrowReader.getVectorSchemaRoot();
                    Schema arrowSchema = arrowRoot.getSchema();
                    LOGGER.debug("Arrow Input file size: " + arrowFile.length());
                    LOGGER.debug("ARROW schema: " + arrowSchema);
                    LOGGER.debug("JSON Input file size: " + jsonFile.length());
                    LOGGER.debug("JSON schema: " + jsonSchema);
                    Validator.compareSchemas((Schema)jsonSchema, (Schema)arrowSchema);
                    List recordBatches = arrowReader.getRecordBlocks();
                    Iterator iterator = recordBatches.iterator();
                    int totalBatches = 0;
                    while ((jsonRoot = jsonReader.read()) != null && iterator.hasNext()) {
                        ArrowBlock rbBlock = (ArrowBlock)iterator.next();
                        if (!arrowReader.loadRecordBatch(rbBlock)) {
                            throw new IOException("Expected to load record batch");
                        }
                        Validator.compareVectorSchemaRoot((VectorSchemaRoot)arrowRoot, (VectorSchemaRoot)jsonRoot);
                        jsonRoot.close();
                        ++totalBatches;
                    }
                    ArrayList<DictionaryEncoding> encodingsJson = new ArrayList<DictionaryEncoding>();
                    Integration.extractDictionaryEncodings(jsonSchema.getFields(), encodingsJson);
                    ArrayList<DictionaryEncoding> encodingsArrow = new ArrayList<DictionaryEncoding>();
                    Integration.extractDictionaryEncodings(arrowSchema.getFields(), encodingsArrow);
                    Validator.compareDictionaries(encodingsJson, encodingsArrow, (DictionaryProvider)jsonReader, (DictionaryProvider)arrowReader);
                    boolean hasMoreJSON = jsonRoot != null;
                    boolean hasMoreArrow = iterator.hasNext();
                    if (hasMoreJSON || hasMoreArrow) {
                        throw new IllegalArgumentException("Unexpected RecordBatches. Total: " + totalBatches + " J:" + hasMoreJSON + " A:" + hasMoreArrow);
                    }
                }
            }
        };

        public final boolean arrowExists;
        public final boolean jsonExists;

        private Command(boolean arrowExists, boolean jsonExists) {
            this.arrowExists = arrowExists;
            this.jsonExists = jsonExists;
        }

        public abstract void execute(File var1, File var2) throws IOException;
    }
}

