/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class VectorUnloaderBenchmark {
    private static final int ALLOCATOR_CAPACITY = 0x100000;
    private static final int VECTOR_COUNT = 10;
    private BufferAllocator allocator;
    private VarCharVector[] vectors;
    private VectorUnloader unloader;
    private ArrowRecordBatch recordBatch;

    @Setup(value=Level.Trial)
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @Setup(value=Level.Invocation)
    public void prepareInvoke() {
        this.vectors = new VarCharVector[10];
        for (int i = 0; i < 10; ++i) {
            this.vectors[i] = new VarCharVector("vector", this.allocator);
            this.vectors[i].allocateNew(100L, 10);
        }
        this.unloader = new VectorUnloader(VectorSchemaRoot.of((FieldVector[])this.vectors));
    }

    @TearDown(value=Level.Invocation)
    public void tearDownInvoke() {
        if (this.recordBatch != null) {
            this.recordBatch.close();
        }
        for (int i = 0; i < 10; ++i) {
            this.vectors[i].close();
        }
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        this.allocator.close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void unloadBenchmark() {
        this.recordBatch = this.unloader.getRecordBatch();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(VectorUnloaderBenchmark.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

