/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class VarCharBenchmarks {
    private static final int VECTOR_LENGTH = 1024;
    private static final int ALLOCATOR_CAPACITY = 0x100000;
    private BufferAllocator allocator;
    private VarCharVector vector;
    private VarCharVector fromVector;

    @Setup
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
        this.vector = new VarCharVector("vector", this.allocator);
        this.vector.allocateNew(262144L, 1024);
        this.fromVector = new VarCharVector("vector", this.allocator);
        this.fromVector.allocateNew(262144L, 1024);
        for (int i = 0; i < 1024; ++i) {
            if (i % 3 == 0) {
                this.fromVector.setNull(i);
                continue;
            }
            this.fromVector.set(i, String.valueOf(i * 1000).getBytes());
        }
        this.fromVector.setValueCount(1024);
    }

    @TearDown
    public void tearDown() {
        this.vector.close();
        this.fromVector.close();
        this.allocator.close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void copyFromBenchmark() {
        for (int i = 0; i < 1024; ++i) {
            this.vector.copyFrom(i, i, (ValueVector)this.fromVector);
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(VarCharBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

