/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.ipc.message;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class ArrowRecordBatchBenchmarks {
    private static final int VECTOR_CAPACITY = 16384;
    private static final int VECTOR_LENGTH = 1024;
    private static final int ALLOCATOR_CAPACITY = 0x100000;
    private BufferAllocator allocator;
    private VarCharVector vector;
    private List<ArrowFieldNode> nodes;

    @Setup
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
        this.vector = new VarCharVector("vector", this.allocator);
        this.vector.allocateNew(16384L, 1024);
        this.nodes = new ArrayList<ArrowFieldNode>();
        this.nodes.add(new ArrowFieldNode(1024L, 0L));
        this.nodes.add(new ArrowFieldNode(1024L, 0L));
    }

    @TearDown
    public void tearDown() {
        this.vector.close();
        this.allocator.close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public long createAndGetLength() {
        try (ArrowRecordBatch batch = new ArrowRecordBatch(1024, this.nodes, this.vector.getFieldBuffers());){
            long l = batch.computeBodyLength();
            return l;
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(ArrowRecordBatchBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

