/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.dictionary;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryEncoder;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class DictionaryEncoderBenchmarks {
    private BufferAllocator allocator;
    private static final int DATA_SIZE = 1000;
    private static final int KEY_SIZE = 100;
    private static final int KEY_LENGTH = 10;
    private List<String> keys = new ArrayList<String>();
    private VarCharVector vector;
    private VarCharVector dictionaryVector;

    @Setup
    public void prepare() {
        byte[] value;
        int i;
        for (i = 0; i < 100; ++i) {
            this.keys.add(this.generateUniqueKey(10));
        }
        this.allocator = new RootAllocator(0xA00000L);
        this.vector = new VarCharVector("vector", this.allocator);
        this.dictionaryVector = new VarCharVector("dict", this.allocator);
        this.vector.allocateNew(10240L, 1000);
        this.vector.setValueCount(1000);
        for (i = 0; i < 1000; ++i) {
            value = this.keys.get(this.generateRandomIndex(100)).getBytes(StandardCharsets.UTF_8);
            this.vector.setSafe(i, value, 0, value.length);
        }
        this.dictionaryVector.allocateNew(1024L, 100);
        this.dictionaryVector.setValueCount(100);
        for (i = 0; i < 100; ++i) {
            value = this.keys.get(i).getBytes(StandardCharsets.UTF_8);
            this.dictionaryVector.setSafe(i, value, 0, value.length);
        }
    }

    @TearDown
    public void tearDown() {
        this.vector.close();
        this.dictionaryVector.close();
        this.keys.clear();
        this.allocator.close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public int testEncode() {
        Dictionary dictionary = new Dictionary((FieldVector)this.dictionaryVector, new DictionaryEncoding(1L, false, null));
        ValueVector encoded = DictionaryEncoder.encode((ValueVector)this.vector, (Dictionary)dictionary);
        encoded.close();
        return 0;
    }

    private int generateRandomIndex(int max) {
        Random random = new Random();
        return random.nextInt(max);
    }

    private String generateUniqueKey(int length) {
        String str = "abcdefghijklmnopqrstuvwxyz";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(26);
            sb.append(str.charAt(number));
        }
        if (this.keys.contains(sb.toString())) {
            return this.generateUniqueKey(length);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(DictionaryEncoderBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

