/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.complex.impl.IntWriterImpl;
import org.apache.arrow.vector.holders.NullableIntHolder;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class IntBenchmarks {
    private static final int VECTOR_LENGTH = 1024;
    private static final int ALLOCATOR_CAPACITY = 0x100000;
    private BufferAllocator allocator;
    private IntVector vector;

    @Setup
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
        this.vector = new IntVector("vector", this.allocator);
        this.vector.allocateNew(1024);
        this.vector.setValueCount(1024);
    }

    @TearDown
    public void tearDown() {
        this.vector.close();
        this.allocator.close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void setWithValueHolder() {
        for (int i = 0; i < 1024; ++i) {
            NullableIntHolder holder = new NullableIntHolder();
            int n = holder.isSet = i % 3 == 0 ? 0 : 1;
            if (holder.isSet == 1) {
                holder.value = i;
            }
            this.vector.setSafe(i, holder);
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void setIntDirectly() {
        for (int i = 0; i < 1024; ++i) {
            this.vector.setSafe(i, i % 3 == 0 ? 0 : 1, i);
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void setWithWriter() {
        IntWriterImpl writer = new IntWriterImpl(this.vector);
        for (int i = 0; i < 1024; ++i) {
            if (i % 3 == 0) continue;
            writer.writeInt(i);
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(IntBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

