/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.DecimalVector;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class DecimalVectorBenchmarks {
    private static final int VECTOR_LENGTH = 1024;
    private static final int ALLOCATOR_CAPACITY = 0x100000;
    private BufferAllocator allocator;
    private DecimalVector vector;
    private ArrowBuf fromBuf;
    byte[] fromByteArray;

    @Setup
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
        this.vector = new DecimalVector("vector", this.allocator, 38, 16);
        this.vector.allocateNew(1024);
        this.fromBuf = this.allocator.buffer(16384L);
        for (int i = 0; i < 1024; ++i) {
            byte[] bytes = BigDecimal.valueOf(i).unscaledValue().toByteArray();
            this.fromBuf.setBytes((long)(i * 16), bytes);
        }
        this.fromByteArray = new byte[16];
        this.fromBuf.getBytes(0L, this.fromByteArray);
    }

    @TearDown
    public void tearDown() {
        this.fromBuf.close();
        this.vector.close();
        this.allocator.close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void setBigEndianArrowBufBenchmark() {
        int offset = 0;
        for (int i = 0; i < 1024; ++i) {
            this.vector.setBigEndianSafe(i, (long)offset, this.fromBuf, 16);
            offset += 8;
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void setBigEndianByteArrayBenchmark() {
        for (int i = 0; i < 1024; ++i) {
            this.vector.setBigEndian(i, this.fromByteArray);
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(DecimalVectorBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

