/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util;

import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.ByteFunctionHelpers;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class ByteFunctionHelpersBenchmarks {
    private static final int ALLOCATOR_CAPACITY = 0x100000;

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void arrowBufEquals(ArrowEqualState state) {
        ByteFunctionHelpers.equal((ArrowBuf)state.buffer1, (long)0L, (long)6L, (ArrowBuf)state.buffer2, (long)0L, (long)6L);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public int arrowBufArrayEquals(ArrowArrayEqualState state) {
        return ByteFunctionHelpers.compare((ArrowBuf)state.buffer1, (int)0, (int)1024, (byte[])state.buffer2, (int)0, (int)1024);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(ByteFunctionHelpersBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Benchmark)
    public static class ArrowArrayEqualState {
        private static final int BUFFER_CAPACITY = 1024;
        private BufferAllocator allocator;
        private ArrowBuf buffer1;
        private byte[] buffer2;

        @Setup(value=Level.Trial)
        public void prepare() {
            this.allocator = new RootAllocator(0x100000L);
            this.buffer1 = this.allocator.buffer(1024L);
            this.buffer2 = new byte[1024];
            for (int i = 0; i < 1024; ++i) {
                this.buffer1.setByte((long)i, i);
                this.buffer2[i] = (byte)i;
            }
        }

        @TearDown(value=Level.Trial)
        public void tearDown() {
            this.buffer1.close();
            this.allocator.close();
        }
    }

    @State(value=Scope.Benchmark)
    public static class ArrowEqualState {
        private static final int BUFFER_CAPACITY = 7;
        private BufferAllocator allocator;
        private ArrowBuf buffer1;
        private ArrowBuf buffer2;

        @Setup(value=Level.Trial)
        public void prepare() {
            this.allocator = new RootAllocator(0x100000L);
            this.buffer1 = this.allocator.buffer(7L);
            this.buffer2 = this.allocator.buffer(7L);
            for (int i = 0; i < 7; ++i) {
                this.buffer1.setByte((long)i, i);
                this.buffer2.setByte((long)i, i);
            }
        }

        @TearDown(value=Level.Trial)
        public void tearDown() {
            this.buffer1.close();
            this.buffer2.close();
            this.allocator.close();
        }
    }
}

