/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.AllocationListener;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.rounding.RoundingPolicy;
import org.apache.arrow.memory.rounding.SegmentRoundingPolicy;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class AllocatorBenchmarks {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void defaultAllocatorBenchmark() {
        int bufferSize = 1024;
        int numBuffers = 1024;
        try (RootAllocator allocator = new RootAllocator(0x100000L);){
            int i;
            ArrowBuf[] buffers = new ArrowBuf[1024];
            for (i = 0; i < 1024; ++i) {
                buffers[i] = allocator.buffer(1024L);
            }
            for (i = 0; i < 1024; ++i) {
                buffers[i].close();
            }
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void segmentRoundingPolicyBenchmark() {
        int bufferSize = 1024;
        int numBuffers = 1024;
        int segmentSize = 1024;
        SegmentRoundingPolicy policy = new SegmentRoundingPolicy(1024);
        try (RootAllocator allocator = new RootAllocator(AllocationListener.NOOP, 0x100000L, (RoundingPolicy)policy);){
            int i;
            ArrowBuf[] buffers = new ArrowBuf[1024];
            for (i = 0; i < 1024; ++i) {
                buffers[i] = allocator.buffer(1024L);
            }
            for (i = 0; i < 1024; ++i) {
                buffers[i].close();
            }
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(AllocatorBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

