/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.search;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.algorithm.search.ParallelSearcher;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class ParallelSearcherBenchmarks {
    private static final int VECTOR_LENGTH = 0x100000;

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void searchBenchmark(SearchState state) throws Exception {
        state.searcher.search((ValueVector)state.keyVector, 0);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(ParallelSearcherBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Benchmark)
    public static class SearchState {
        @Param(value={"1", "2", "5", "10", "20", "50", "100"})
        int numThreads;
        BufferAllocator allocator;
        ExecutorService threadPool;
        IntVector targetVector;
        IntVector keyVector;
        ParallelSearcher<IntVector> searcher;

        @Setup(value=Level.Trial)
        public void prepare() {
            this.allocator = new RootAllocator(Integer.MAX_VALUE);
            this.targetVector = new IntVector("target vector", this.allocator);
            this.targetVector.allocateNew(0x100000);
            this.keyVector = new IntVector("key vector", this.allocator);
            this.keyVector.allocateNew(1);
            this.threadPool = Executors.newFixedThreadPool(this.numThreads);
            for (int i = 0; i < 0x100000; ++i) {
                this.targetVector.set(i, i);
            }
            this.targetVector.setValueCount(0x100000);
            this.keyVector.set(0, 349525);
            this.keyVector.setValueCount(1);
        }

        @Setup(value=Level.Invocation)
        public void prepareInvoke() {
            this.searcher = new ParallelSearcher((ValueVector)this.targetVector, this.threadPool, this.numThreads);
        }

        @TearDown(value=Level.Trial)
        public void tearDownState() {
            this.targetVector.close();
            this.keyVector.close();
            this.allocator.close();
            this.threadPool.shutdown();
        }
    }
}

