/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import com.google.common.base.Preconditions;
import io.netty.buffer.ArrowBuf;
import io.netty.buffer.UnsafeDirectLittleEndian;
import io.netty.util.internal.OutOfDirectMemoryError;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.arrow.memory.Accountant;
import org.apache.arrow.memory.AllocationListener;
import org.apache.arrow.memory.AllocationManager;
import org.apache.arrow.memory.AllocationReservation;
import org.apache.arrow.memory.ArrowByteBufAllocator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.BufferManager;
import org.apache.arrow.memory.ChildAllocator;
import org.apache.arrow.memory.OutOfMemoryException;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.AssertionUtil;
import org.apache.arrow.memory.util.HistoricalLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAllocator
extends Accountant
implements BufferAllocator {
    public static final String DEBUG_ALLOCATOR = "arrow.memory.debug.allocator";
    public static final int DEBUG_LOG_LENGTH = 6;
    public static final boolean DEBUG = AssertionUtil.isAssertionsEnabled() || Boolean.parseBoolean(System.getProperty("arrow.memory.debug.allocator", "false"));
    private static final Logger logger = LoggerFactory.getLogger(BaseAllocator.class);
    final String name;
    final RootAllocator root;
    private final Object DEBUG_LOCK = DEBUG ? new Object() : null;
    private final AllocationListener listener;
    private final BaseAllocator parentAllocator;
    private final ArrowByteBufAllocator thisAsByteBufAllocator;
    private final IdentityHashMap<BaseAllocator, Object> childAllocators;
    private final ArrowBuf empty;
    private final IdentityHashMap<AllocationManager.BufferLedger, Object> childLedgers;
    private final IdentityHashMap<Reservation, Object> reservations;
    private final HistoricalLog historicalLog;
    private volatile boolean isClosed = false;

    protected BaseAllocator(AllocationListener listener, String name, long initReservation, long maxAllocation) throws OutOfMemoryException {
        this(listener, null, name, initReservation, maxAllocation);
    }

    protected BaseAllocator(BaseAllocator parentAllocator, String name, long initReservation, long maxAllocation) throws OutOfMemoryException {
        this(parentAllocator.listener, parentAllocator, name, initReservation, maxAllocation);
    }

    private BaseAllocator(AllocationListener listener, BaseAllocator parentAllocator, String name, long initReservation, long maxAllocation) throws OutOfMemoryException {
        super(parentAllocator, initReservation, maxAllocation);
        this.listener = listener;
        if (parentAllocator != null) {
            this.root = parentAllocator.root;
            this.empty = parentAllocator.empty;
        } else if (this instanceof RootAllocator) {
            this.root = (RootAllocator)this;
            this.empty = this.createEmpty();
        } else {
            throw new IllegalStateException("An parent allocator must either carry a root or be the root.");
        }
        this.parentAllocator = parentAllocator;
        this.name = name;
        this.thisAsByteBufAllocator = new ArrowByteBufAllocator(this);
        if (DEBUG) {
            this.childAllocators = new IdentityHashMap();
            this.reservations = new IdentityHashMap();
            this.childLedgers = new IdentityHashMap();
            this.historicalLog = new HistoricalLog(6, "allocator[%s]", name);
            this.hist("created by \"%s\", owned = %d", name, this.getAllocatedMemory());
        } else {
            this.childAllocators = null;
            this.reservations = null;
            this.historicalLog = null;
            this.childLedgers = null;
        }
    }

    private static String createErrorMsg(BufferAllocator allocator, int rounded, int requested) {
        if (rounded != requested) {
            return String.format("Unable to allocate buffer of size %d (rounded from %d) due to memory limit. Current allocation: %d", rounded, requested, allocator.getAllocatedMemory());
        }
        return String.format("Unable to allocate buffer of size %d due to memory limit. Current allocation: %d", rounded, allocator.getAllocatedMemory());
    }

    public static int nextPowerOfTwo(int val) {
        if (val == 0 || val == 1) {
            return val + 1;
        }
        int highestBit = Integer.highestOneBit(val);
        if (highestBit == val) {
            return val;
        }
        return highestBit << 1;
    }

    public static long nextPowerOfTwo(long val) {
        if (val == 0L || val == 1L) {
            return val + 1L;
        }
        long highestBit = Long.highestOneBit(val);
        if (highestBit == val) {
            return val;
        }
        return highestBit << 1;
    }

    public static StringBuilder indent(StringBuilder sb, int indent) {
        char[] indentation = new char[indent * 2];
        Arrays.fill(indentation, ' ');
        sb.append(indentation);
        return sb;
    }

    public static boolean isDebug() {
        return DEBUG;
    }

    @Override
    public void assertOpen() {
        if (AssertionUtil.ASSERT_ENABLED && this.isClosed) {
            throw new IllegalStateException("Attempting operation on allocator when allocator is closed.\n" + this.toVerboseString());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ArrowBuf getEmpty() {
        return this.empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void associateLedger(AllocationManager.BufferLedger ledger) {
        this.assertOpen();
        if (DEBUG) {
            Object object = this.DEBUG_LOCK;
            synchronized (object) {
                this.childLedgers.put(ledger, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dissociateLedger(AllocationManager.BufferLedger ledger) {
        this.assertOpen();
        if (DEBUG) {
            Object object = this.DEBUG_LOCK;
            synchronized (object) {
                if (!this.childLedgers.containsKey(ledger)) {
                    throw new IllegalStateException("Trying to remove a child ledger that doesn't exist.");
                }
                this.childLedgers.remove(ledger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void childClosed(BaseAllocator childAllocator) {
        this.assertOpen();
        if (DEBUG) {
            Preconditions.checkArgument((childAllocator != null ? 1 : 0) != 0, (Object)"child allocator can't be null");
            Object object = this.DEBUG_LOCK;
            synchronized (object) {
                Object object2 = this.childAllocators.remove(childAllocator);
                if (object2 == null) {
                    childAllocator.historicalLog.logHistory(logger);
                    throw new IllegalStateException("Child allocator[" + childAllocator.name + "] not found in parent allocator[" + this.name + "]'s childAllocators");
                }
            }
        }
    }

    @Override
    public ArrowBuf buffer(int initialRequestSize) {
        this.assertOpen();
        return this.buffer(initialRequestSize, null);
    }

    private ArrowBuf createEmpty() {
        return new ArrowBuf(new AtomicInteger(), null, AllocationManager.EMPTY, null, null, 0, 0, true);
    }

    @Override
    public ArrowBuf buffer(int initialRequestSize, BufferManager manager) {
        this.assertOpen();
        Preconditions.checkArgument((initialRequestSize >= 0 ? 1 : 0) != 0, (Object)"the requested size must be non-negative");
        if (initialRequestSize == 0) {
            return this.empty;
        }
        int actualRequestSize = (long)initialRequestSize < AllocationManager.CHUNK_SIZE ? BaseAllocator.nextPowerOfTwo(initialRequestSize) : initialRequestSize;
        Accountant.AllocationOutcome outcome = this.allocateBytes(actualRequestSize);
        if (!outcome.isOk()) {
            throw new OutOfMemoryException(BaseAllocator.createErrorMsg(this, actualRequestSize, initialRequestSize));
        }
        boolean success = false;
        try {
            ArrowBuf buffer = this.bufferWithoutReservation(actualRequestSize, manager);
            success = true;
            this.listener.onAllocation(actualRequestSize);
            ArrowBuf arrowBuf = buffer;
            return arrowBuf;
        }
        catch (OutOfMemoryError e) {
            if (e instanceof OutOfDirectMemoryError || "Direct buffer memory".equals(e.getMessage())) {
                throw new OutOfMemoryException(e);
            }
            throw e;
        }
        finally {
            if (!success) {
                this.releaseBytes(actualRequestSize);
            }
        }
    }

    private ArrowBuf bufferWithoutReservation(int size, BufferManager bufferManager) throws OutOfMemoryException {
        this.assertOpen();
        AllocationManager manager = new AllocationManager(this, size);
        AllocationManager.BufferLedger ledger = manager.associate(this);
        ArrowBuf buffer = ledger.newArrowBuf(0, size, bufferManager);
        Preconditions.checkArgument((buffer.capacity() == size ? 1 : 0) != 0, (String)"Allocated capacity %d was not equal to requested capacity %d.", (Object[])new Object[]{buffer.capacity(), size});
        return buffer;
    }

    public ArrowByteBufAllocator getAsByteBufAllocator() {
        return this.thisAsByteBufAllocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferAllocator newChildAllocator(String name, long initReservation, long maxAllocation) {
        this.assertOpen();
        ChildAllocator childAllocator = new ChildAllocator(this, name, initReservation, maxAllocation);
        if (DEBUG) {
            Object object = this.DEBUG_LOCK;
            synchronized (object) {
                this.childAllocators.put(childAllocator, childAllocator);
                this.historicalLog.recordEvent("allocator[%s] created new child allocator[%s]", name, childAllocator.name);
            }
        }
        return childAllocator;
    }

    @Override
    public AllocationReservation newReservation() {
        this.assertOpen();
        return new Reservation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        long allocated;
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (DEBUG) {
            Object object = this.DEBUG_LOCK;
            synchronized (object) {
                this.verifyAllocator();
                if (!this.childAllocators.isEmpty()) {
                    for (BaseAllocator childAllocator : this.childAllocators.keySet()) {
                        if (!childAllocator.isClosed) continue;
                        logger.warn(String.format("Closed child allocator[%s] on parent allocator[%s]'s child list.\n%s", childAllocator.name, this.name, this.toString()));
                    }
                    throw new IllegalStateException(String.format("Allocator[%s] closed with outstanding child allocators.\n%s", this.name, this.toString()));
                }
                int allocatedCount = this.childLedgers.size();
                if (allocatedCount > 0) {
                    throw new IllegalStateException(String.format("Allocator[%s] closed with outstanding buffers allocated (%d).\n%s", this.name, allocatedCount, this.toString()));
                }
                if (this.reservations.size() != 0) {
                    throw new IllegalStateException(String.format("Allocator[%s] closed with outstanding reservations (%d).\n%s", this.name, this.reservations.size(), this.toString()));
                }
            }
        }
        if ((allocated = this.getAllocatedMemory()) > 0L) {
            throw new IllegalStateException(String.format("Memory was leaked by query. Memory leaked: (%d)\n%s", allocated, this.toString()));
        }
        super.close();
        if (this.parentAllocator != null) {
            this.parentAllocator.childClosed(this);
        }
        if (DEBUG) {
            this.historicalLog.recordEvent("closed", new Object[0]);
            logger.debug(String.format("closed allocator[%s].", this.name));
        }
    }

    public String toString() {
        Verbosity verbosity = logger.isTraceEnabled() ? Verbosity.LOG_WITH_STACKTRACE : Verbosity.BASIC;
        StringBuilder sb = new StringBuilder();
        this.print(sb, 0, verbosity);
        return sb.toString();
    }

    @Override
    public String toVerboseString() {
        StringBuilder sb = new StringBuilder();
        this.print(sb, 0, Verbosity.LOG_WITH_STACKTRACE);
        return sb.toString();
    }

    private void hist(String noteFormat, Object ... args) {
        this.historicalLog.recordEvent(noteFormat, args);
    }

    void verifyAllocator() {
        IdentityHashMap<UnsafeDirectLittleEndian, BaseAllocator> buffersSeen = new IdentityHashMap<UnsafeDirectLittleEndian, BaseAllocator>();
        this.verifyAllocator(buffersSeen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAllocator(IdentityHashMap<UnsafeDirectLittleEndian, BaseAllocator> buffersSeen) {
        if (!DEBUG) {
            return;
        }
        Object object = this.DEBUG_LOCK;
        synchronized (object) {
            long allocated = this.getAllocatedMemory();
            Set<BaseAllocator> childSet = this.childAllocators.keySet();
            for (BaseAllocator childAllocator : childSet) {
                childAllocator.verifyAllocator(buffersSeen);
            }
            long childTotal = 0L;
            for (BaseAllocator childAllocator : childSet) {
                childTotal += Math.max(childAllocator.getAllocatedMemory(), childAllocator.reservation);
            }
            if (childTotal > this.getAllocatedMemory()) {
                this.historicalLog.logHistory(logger);
                logger.debug("allocator[" + this.name + "] child event logs BEGIN");
                for (BaseAllocator childAllocator : childSet) {
                    childAllocator.historicalLog.logHistory(logger);
                }
                logger.debug("allocator[" + this.name + "] child event logs END");
                throw new IllegalStateException("Child allocators own more memory (" + childTotal + ") than their parent (name = " + this.name + " ) has allocated (" + this.getAllocatedMemory() + ')');
            }
            long bufferTotal = 0L;
            Set<AllocationManager.BufferLedger> ledgerSet = this.childLedgers.keySet();
            for (AllocationManager.BufferLedger ledger : ledgerSet) {
                if (!ledger.isOwningLedger()) continue;
                UnsafeDirectLittleEndian udle = ledger.getUnderlying();
                BaseAllocator otherOwner = buffersSeen.get((Object)udle);
                if (otherOwner != null) {
                    throw new IllegalStateException("This allocator's ArrowBuf already owned by another allocator");
                }
                buffersSeen.put(udle, this);
                bufferTotal += (long)udle.capacity();
            }
            Set<Reservation> reservationSet = this.reservations.keySet();
            long reservedTotal = 0L;
            for (Reservation reservation : reservationSet) {
                if (reservation.isUsed()) continue;
                reservedTotal += (long)reservation.getSize();
            }
            if (bufferTotal + reservedTotal + childTotal != this.getAllocatedMemory()) {
                StringBuilder sb = new StringBuilder();
                sb.append("allocator[");
                sb.append(this.name);
                sb.append("]\nallocated: ");
                sb.append(Long.toString(allocated));
                sb.append(" allocated - (bufferTotal + reservedTotal + childTotal): ");
                sb.append(Long.toString(allocated - (bufferTotal + reservedTotal + childTotal)));
                sb.append('\n');
                if (bufferTotal != 0L) {
                    sb.append("buffer total: ");
                    sb.append(Long.toString(bufferTotal));
                    sb.append('\n');
                    this.dumpBuffers(sb, ledgerSet);
                }
                if (childTotal != 0L) {
                    sb.append("child total: ");
                    sb.append(Long.toString(childTotal));
                    sb.append('\n');
                    for (BaseAllocator childAllocator : childSet) {
                        sb.append("child allocator[");
                        sb.append(childAllocator.name);
                        sb.append("] owned ");
                        sb.append(Long.toString(childAllocator.getAllocatedMemory()));
                        sb.append('\n');
                    }
                }
                if (reservedTotal != 0L) {
                    sb.append(String.format("reserved total : %d bytes.", reservedTotal));
                    for (Reservation reservation : reservationSet) {
                        reservation.historicalLog.buildHistory(sb, 0, true);
                        sb.append('\n');
                    }
                }
                logger.debug(sb.toString());
                long l = this.getAllocatedMemory();
                if (l != allocated) {
                    throw new IllegalStateException(String.format("allocator[%s]: allocated t1 (%d) + allocated t2 (%d). Someone released memory while in verification.", this.name, allocated, l));
                }
                throw new IllegalStateException(String.format("allocator[%s]: buffer space (%d) + prealloc space (%d) + child space (%d) != allocated (%d)", this.name, bufferTotal, reservedTotal, childTotal, allocated));
            }
        }
    }

    void print(StringBuilder sb, int level, Verbosity verbosity) {
        BaseAllocator.indent(sb, level).append("Allocator(").append(this.name).append(") ").append(this.reservation).append('/').append(this.getAllocatedMemory()).append('/').append(this.getPeakMemoryAllocation()).append('/').append(this.getLimit()).append(" (res/actual/peak/limit)").append('\n');
        if (DEBUG) {
            BaseAllocator.indent(sb, level + 1).append(String.format("child allocators: %d\n", this.childAllocators.size()));
            for (BaseAllocator child : this.childAllocators.keySet()) {
                child.print(sb, level + 2, verbosity);
            }
            BaseAllocator.indent(sb, level + 1).append(String.format("ledgers: %d\n", this.childLedgers.size()));
            for (AllocationManager.BufferLedger ledger : this.childLedgers.keySet()) {
                ledger.print(sb, level + 2, verbosity);
            }
            Set<Reservation> reservations = this.reservations.keySet();
            BaseAllocator.indent(sb, level + 1).append(String.format("reservations: %d\n", reservations.size()));
            for (Reservation reservation : reservations) {
                if (!verbosity.includeHistoricalLog) continue;
                reservation.historicalLog.buildHistory(sb, level + 3, true);
            }
        }
    }

    private void dumpBuffers(StringBuilder sb, Set<AllocationManager.BufferLedger> ledgerSet) {
        for (AllocationManager.BufferLedger ledger : ledgerSet) {
            if (!ledger.isOwningLedger()) continue;
            UnsafeDirectLittleEndian udle = ledger.getUnderlying();
            sb.append("UnsafeDirectLittleEndian[identityHashCode == ");
            sb.append(Integer.toString(System.identityHashCode((Object)udle)));
            sb.append("] size ");
            sb.append(Integer.toString(udle.capacity()));
            sb.append('\n');
        }
    }

    public class Reservation
    implements AllocationReservation {
        private final HistoricalLog historicalLog;
        private int nBytes = 0;
        private boolean used = false;
        private boolean closed = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Reservation() {
            if (DEBUG) {
                this.historicalLog = new HistoricalLog("Reservation[allocator[%s], %d]", BaseAllocator.this.name, System.identityHashCode(this));
                this.historicalLog.recordEvent("created", new Object[0]);
                Object object = BaseAllocator.this.DEBUG_LOCK;
                synchronized (object) {
                    BaseAllocator.this.reservations.put(this, this);
                }
            } else {
                this.historicalLog = null;
            }
        }

        @Override
        public boolean add(int nBytes) {
            BaseAllocator.this.assertOpen();
            Preconditions.checkArgument((nBytes >= 0 ? 1 : 0) != 0, (String)"nBytes(%d) < 0", (Object[])new Object[]{nBytes});
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Attempt to increase reservation after reservation has been closed");
            Preconditions.checkState((!this.used ? 1 : 0) != 0, (Object)"Attempt to increase reservation after reservation has been used");
            int nBytesTwo = BaseAllocator.nextPowerOfTwo(nBytes);
            if (!this.reserve(nBytesTwo)) {
                return false;
            }
            this.nBytes += nBytesTwo;
            return true;
        }

        @Override
        public ArrowBuf allocateBuffer() {
            BaseAllocator.this.assertOpen();
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Attempt to allocate after closed");
            Preconditions.checkState((!this.used ? 1 : 0) != 0, (Object)"Attempt to allocate more than once");
            ArrowBuf arrowBuf = this.allocate(this.nBytes);
            this.used = true;
            return arrowBuf;
        }

        @Override
        public int getSize() {
            return this.nBytes;
        }

        @Override
        public boolean isUsed() {
            return this.used;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            BaseAllocator.this.assertOpen();
            if (this.closed) {
                return;
            }
            if (DEBUG && !this.isClosed()) {
                Object object;
                Object object2 = BaseAllocator.this.DEBUG_LOCK;
                synchronized (object2) {
                    object = BaseAllocator.this.reservations.remove(this);
                }
                if (object == null) {
                    StringBuilder sb = new StringBuilder();
                    BaseAllocator.this.print(sb, 0, Verbosity.LOG_WITH_STACKTRACE);
                    logger.debug(sb.toString());
                    throw new IllegalStateException(String.format("Didn't find closing reservation[%d]", System.identityHashCode(this)));
                }
                this.historicalLog.recordEvent("closed", new Object[0]);
            }
            if (!this.used) {
                this.releaseReservation(this.nBytes);
            }
            this.closed = true;
        }

        @Override
        public boolean reserve(int nBytes) {
            BaseAllocator.this.assertOpen();
            Accountant.AllocationOutcome outcome = BaseAllocator.this.allocateBytes(nBytes);
            if (DEBUG) {
                this.historicalLog.recordEvent("reserve(%d) => %s", nBytes, Boolean.toString(outcome.isOk()));
            }
            return outcome.isOk();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ArrowBuf allocate(int nBytes) {
            BaseAllocator.this.assertOpen();
            boolean success = false;
            try {
                ArrowBuf arrowBuf = BaseAllocator.this.bufferWithoutReservation(nBytes, null);
                BaseAllocator.this.listener.onAllocation(nBytes);
                if (DEBUG) {
                    this.historicalLog.recordEvent("allocate() => %s", String.format("ArrowBuf[%d]", arrowBuf.getId()));
                }
                success = true;
                ArrowBuf arrowBuf2 = arrowBuf;
                return arrowBuf2;
            }
            finally {
                if (!success) {
                    BaseAllocator.this.releaseBytes(nBytes);
                }
            }
        }

        private void releaseReservation(int nBytes) {
            BaseAllocator.this.assertOpen();
            BaseAllocator.this.releaseBytes(nBytes);
            if (DEBUG) {
                this.historicalLog.recordEvent("releaseReservation(%d)", nBytes);
            }
        }
    }

    public static enum Verbosity {
        BASIC(false, false),
        LOG(true, false),
        LOG_WITH_STACKTRACE(true, true);

        public final boolean includeHistoricalLog;
        public final boolean includeStackTraces;

        private Verbosity(boolean includeHistoricalLog, boolean includeStackTraces) {
            this.includeHistoricalLog = includeHistoricalLog;
            this.includeStackTraces = includeStackTraces;
        }
    }
}

