/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.rounding;

import org.apache.arrow.memory.rounding.RoundingPolicy;
import org.apache.arrow.util.Preconditions;

public class SegmentRoundingPolicy
implements RoundingPolicy {
    public static final long MIN_SEGMENT_SIZE = 1024L;
    private int segmentSize;

    public SegmentRoundingPolicy(int segmentSize) {
        Preconditions.checkArgument((long)segmentSize >= 1024L, "The segment size cannot be smaller than 1024");
        Preconditions.checkArgument((segmentSize & segmentSize - 1) == 0, "The segment size must be a power of 2");
        this.segmentSize = segmentSize;
    }

    @Override
    public int getRoundedSize(int requestSize) {
        return (requestSize + (this.segmentSize - 1)) / this.segmentSize * this.segmentSize;
    }

    public int getSegmentSize() {
        return this.segmentSize;
    }
}

