/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import io.netty.util.internal.PlatformDependent;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.VarCharVector;

public abstract class ClobConsumer
extends BaseConsumer<VarCharVector> {
    private static final int BUFFER_SIZE = 256;

    public static ClobConsumer createConsumer(VarCharVector vector, int index, boolean nullable) {
        if (nullable) {
            return new NullableClobConsumer(vector, index);
        }
        return new NonNullableClobConsumer(vector, index);
    }

    public ClobConsumer(VarCharVector vector, int index) {
        super(vector, index);
        if (vector != null) {
            vector.allocateNewSafe();
        }
    }

    @Override
    public void resetValueVector(VarCharVector vector) {
        this.vector = vector;
        ((VarCharVector)this.vector).allocateNewSafe();
        this.currentIndex = 0;
    }

    static class NonNullableClobConsumer
    extends ClobConsumer {
        public NonNullableClobConsumer(VarCharVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            Clob clob = resultSet.getClob(this.columnIndexInResultSet);
            if (clob != null) {
                long length = clob.length();
                int read = 1;
                int readSize = length < 256L ? (int)length : 256;
                int totalBytes = 0;
                ArrowBuf dataBuffer = ((VarCharVector)this.vector).getDataBuffer();
                ArrowBuf offsetBuffer = ((VarCharVector)this.vector).getOffsetBuffer();
                int startIndex = offsetBuffer.getInt((long)(this.currentIndex * 4));
                while ((long)read <= length) {
                    String str = clob.getSubString(read, readSize);
                    byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
                    while (dataBuffer.writerIndex() + (long)bytes.length > dataBuffer.capacity()) {
                        ((VarCharVector)this.vector).reallocDataBuffer();
                    }
                    PlatformDependent.copyMemory((byte[])bytes, (int)0, (long)(dataBuffer.memoryAddress() + (long)startIndex + (long)totalBytes), (long)bytes.length);
                    totalBytes += bytes.length;
                    read += readSize;
                }
                offsetBuffer.setInt((long)((this.currentIndex + 1) * 4), startIndex + totalBytes);
                BitVectorHelper.setBit((ArrowBuf)((VarCharVector)this.vector).getValidityBuffer(), (long)this.currentIndex);
                ((VarCharVector)this.vector).setLastSet(this.currentIndex);
            }
            ++this.currentIndex;
        }
    }

    static class NullableClobConsumer
    extends ClobConsumer {
        public NullableClobConsumer(VarCharVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            Clob clob = resultSet.getClob(this.columnIndexInResultSet);
            if (!resultSet.wasNull() && clob != null) {
                long length = clob.length();
                int read = 1;
                int readSize = length < 256L ? (int)length : 256;
                int totalBytes = 0;
                ArrowBuf dataBuffer = ((VarCharVector)this.vector).getDataBuffer();
                ArrowBuf offsetBuffer = ((VarCharVector)this.vector).getOffsetBuffer();
                int startIndex = offsetBuffer.getInt((long)(this.currentIndex * 4));
                while ((long)read <= length) {
                    String str = clob.getSubString(read, readSize);
                    byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
                    while (dataBuffer.writerIndex() + (long)bytes.length > dataBuffer.capacity()) {
                        ((VarCharVector)this.vector).reallocDataBuffer();
                    }
                    PlatformDependent.copyMemory((byte[])bytes, (int)0, (long)(dataBuffer.memoryAddress() + (long)startIndex + (long)totalBytes), (long)bytes.length);
                    totalBytes += bytes.length;
                    read += readSize;
                }
                offsetBuffer.setInt((long)((this.currentIndex + 1) * 4), startIndex + totalBytes);
                BitVectorHelper.setBit((ArrowBuf)((VarCharVector)this.vector).getValidityBuffer(), (long)this.currentIndex);
                ((VarCharVector)this.vector).setLastSet(this.currentIndex);
            }
            ++this.currentIndex;
        }
    }
}

