/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.consumer.ArrayConsumer;
import org.apache.arrow.adapter.jdbc.consumer.BigIntConsumer;
import org.apache.arrow.adapter.jdbc.consumer.BinaryConsumer;
import org.apache.arrow.adapter.jdbc.consumer.BitConsumer;
import org.apache.arrow.adapter.jdbc.consumer.CompositeJdbcConsumer;
import org.apache.arrow.adapter.jdbc.consumer.DateConsumer;
import org.apache.arrow.adapter.jdbc.consumer.DecimalConsumer;
import org.apache.arrow.adapter.jdbc.consumer.DoubleConsumer;
import org.apache.arrow.adapter.jdbc.consumer.FloatConsumer;
import org.apache.arrow.adapter.jdbc.consumer.IntConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.adapter.jdbc.consumer.NullConsumer;
import org.apache.arrow.adapter.jdbc.consumer.SmallIntConsumer;
import org.apache.arrow.adapter.jdbc.consumer.TimeConsumer;
import org.apache.arrow.adapter.jdbc.consumer.TimestampConsumer;
import org.apache.arrow.adapter.jdbc.consumer.TimestampTZConsumer;
import org.apache.arrow.adapter.jdbc.consumer.TinyIntConsumer;
import org.apache.arrow.adapter.jdbc.consumer.VarCharConsumer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ValueVectorUtility;

public class JdbcToArrowUtils {
    private static final int JDBC_ARRAY_VALUE_COLUMN = 2;

    public static Calendar getUtcCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
    }

    public static Schema jdbcToArrowSchema(ResultSetMetaData rsmd, Calendar calendar) throws SQLException {
        Preconditions.checkNotNull((Object)calendar, (Object)"Calendar object can't be null");
        return JdbcToArrowUtils.jdbcToArrowSchema(rsmd, new JdbcToArrowConfig((BufferAllocator)new RootAllocator(0L), calendar));
    }

    public static Schema jdbcToArrowSchema(ResultSetMetaData rsmd, JdbcToArrowConfig config) throws SQLException {
        Preconditions.checkNotNull((Object)rsmd, (Object)"JDBC ResultSetMetaData object can't be null");
        Preconditions.checkNotNull((Object)config, (Object)"The configuration object must not be null");
        ArrayList<Field> fields = new ArrayList<Field>();
        int columnCount = rsmd.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            HashMap<String, String> metadata;
            String columnName = rsmd.getColumnLabel(i);
            if (config.shouldIncludeMetadata()) {
                metadata = new HashMap<String, String>();
                metadata.put("SQL_CATALOG_NAME", rsmd.getCatalogName(i));
                metadata.put("SQL_TABLE_NAME", rsmd.getTableName(i));
                metadata.put("SQL_COLUMN_NAME", columnName);
                metadata.put("SQL_TYPE", rsmd.getColumnTypeName(i));
            } else {
                metadata = null;
            }
            ArrowType arrowType = config.getJdbcToArrowTypeConverter().apply(new JdbcFieldInfo(rsmd, i));
            if (arrowType == null) continue;
            FieldType fieldType = new FieldType(JdbcToArrowUtils.isColumnNullable(rsmd, i), arrowType, null, metadata);
            ArrayList<Field> children = null;
            if (arrowType.getTypeID() == ArrowType.List.TYPE_TYPE) {
                JdbcFieldInfo arrayFieldInfo = JdbcToArrowUtils.getJdbcFieldInfoForArraySubType(rsmd, i, config);
                if (arrayFieldInfo == null) {
                    throw new IllegalArgumentException("Configuration does not provide a mapping for array column " + i);
                }
                children = new ArrayList<Field>();
                ArrowType childType = config.getJdbcToArrowTypeConverter().apply(arrayFieldInfo);
                children.add(new Field("child", FieldType.nullable((ArrowType)childType), null));
            }
            fields.add(new Field(columnName, fieldType, children));
        }
        return new Schema(fields, null);
    }

    private static JdbcFieldInfo getJdbcFieldInfoForArraySubType(ResultSetMetaData rsmd, int arrayColumn, JdbcToArrowConfig config) throws SQLException {
        Preconditions.checkNotNull((Object)rsmd, (Object)"ResultSet MetaData object cannot be null");
        Preconditions.checkNotNull((Object)config, (Object)"Configuration must not be null");
        Preconditions.checkArgument((arrayColumn > 0 ? 1 : 0) != 0, (Object)"ResultSetMetaData columns start with 1; column cannot be less than 1");
        Preconditions.checkArgument((arrayColumn <= rsmd.getColumnCount() ? 1 : 0) != 0, (Object)"Column number cannot be more than the number of columns");
        JdbcFieldInfo fieldInfo = config.getArraySubTypeByColumnIndex(arrayColumn);
        if (fieldInfo == null) {
            fieldInfo = config.getArraySubTypeByColumnName(rsmd.getColumnLabel(arrayColumn));
        }
        return fieldInfo;
    }

    public static void jdbcToArrowVectors(ResultSet rs, VectorSchemaRoot root, Calendar calendar) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)calendar, (Object)"Calendar object can't be null");
        JdbcToArrowUtils.jdbcToArrowVectors(rs, root, new JdbcToArrowConfig((BufferAllocator)new RootAllocator(0L), calendar));
    }

    static boolean isColumnNullable(ResultSet resultSet, int index) throws SQLException {
        return JdbcToArrowUtils.isColumnNullable(resultSet.getMetaData(), index);
    }

    static boolean isColumnNullable(ResultSetMetaData resultSetMetadata, int index) throws SQLException {
        int nullableValue = resultSetMetadata.isNullable(index);
        return nullableValue == 1 || nullableValue == 2;
    }

    public static void jdbcToArrowVectors(ResultSet rs, VectorSchemaRoot root, JdbcToArrowConfig config) throws SQLException, IOException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        JdbcConsumer[] consumers = new JdbcConsumer[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            FieldVector vector = root.getVector(rsmd.getColumnLabel(i));
            consumers[i - 1] = JdbcToArrowUtils.getConsumer(vector.getField().getType(), i, JdbcToArrowUtils.isColumnNullable(rs, i), vector, config);
        }
        CompositeJdbcConsumer compositeConsumer = null;
        try {
            int readRowCount;
            compositeConsumer = new CompositeJdbcConsumer(consumers);
            if (config.getTargetBatchSize() == -1) {
                while (rs.next()) {
                    ValueVectorUtility.ensureCapacity((VectorSchemaRoot)root, (int)(readRowCount + 1));
                    compositeConsumer.consume(rs);
                    ++readRowCount;
                }
            } else {
                for (readRowCount = 0; rs.next() && readRowCount < config.getTargetBatchSize(); ++readRowCount) {
                    compositeConsumer.consume(rs);
                }
            }
            root.setRowCount(readRowCount);
        }
        catch (Exception e) {
            if (compositeConsumer != null) {
                compositeConsumer.close();
            }
            throw e;
        }
    }

    static JdbcConsumer getConsumer(ArrowType arrowType, int columnIndex, boolean nullable, FieldVector vector, JdbcToArrowConfig config) {
        Calendar calendar = config.getCalendar();
        switch (arrowType.getTypeID()) {
            case Bool: {
                return BitConsumer.createConsumer((BitVector)vector, columnIndex, nullable);
            }
            case Int: {
                switch (((ArrowType.Int)arrowType).getBitWidth()) {
                    case 8: {
                        return TinyIntConsumer.createConsumer((TinyIntVector)vector, columnIndex, nullable);
                    }
                    case 16: {
                        return SmallIntConsumer.createConsumer((SmallIntVector)vector, columnIndex, nullable);
                    }
                    case 32: {
                        return IntConsumer.createConsumer((IntVector)vector, columnIndex, nullable);
                    }
                    case 64: {
                        return BigIntConsumer.createConsumer((BigIntVector)vector, columnIndex, nullable);
                    }
                }
                return null;
            }
            case Decimal: {
                return DecimalConsumer.createConsumer((DecimalVector)vector, columnIndex, nullable);
            }
            case FloatingPoint: {
                switch (((ArrowType.FloatingPoint)arrowType).getPrecision()) {
                    case SINGLE: {
                        return FloatConsumer.createConsumer((Float4Vector)vector, columnIndex, nullable);
                    }
                    case DOUBLE: {
                        return DoubleConsumer.createConsumer((Float8Vector)vector, columnIndex, nullable);
                    }
                }
                return null;
            }
            case Utf8: 
            case LargeUtf8: {
                return VarCharConsumer.createConsumer((VarCharVector)vector, columnIndex, nullable);
            }
            case Binary: 
            case LargeBinary: {
                return BinaryConsumer.createConsumer((VarBinaryVector)vector, columnIndex, nullable);
            }
            case Date: {
                return DateConsumer.createConsumer((DateDayVector)vector, columnIndex, nullable, calendar);
            }
            case Time: {
                return TimeConsumer.createConsumer((TimeMilliVector)vector, columnIndex, nullable, calendar);
            }
            case Timestamp: {
                if (config.getCalendar() == null) {
                    return TimestampConsumer.createConsumer((TimeStampMilliVector)vector, columnIndex, nullable);
                }
                return TimestampTZConsumer.createConsumer((TimeStampMilliTZVector)vector, columnIndex, nullable, calendar);
            }
            case List: {
                FieldVector childVector = ((ListVector)vector).getDataVector();
                JdbcConsumer delegate = JdbcToArrowUtils.getConsumer(childVector.getField().getType(), 2, childVector.getField().isNullable(), childVector, config);
                return ArrayConsumer.createConsumer((ListVector)vector, delegate, columnIndex, nullable);
            }
            case Null: {
                return new NullConsumer((NullVector)vector);
            }
        }
        throw new UnsupportedOperationException();
    }
}

