/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.ArrowVectorIterator;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;

public class JdbcToArrow {
    public static ArrowVectorIterator sqlToArrowVectorIterator(ResultSet resultSet, BufferAllocator allocator) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory Allocator object cannot be null");
        JdbcToArrowConfig config = new JdbcToArrowConfig(allocator, JdbcToArrowUtils.getUtcCalendar());
        return JdbcToArrow.sqlToArrowVectorIterator(resultSet, config);
    }

    public static ArrowVectorIterator sqlToArrowVectorIterator(ResultSet resultSet, JdbcToArrowConfig config) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)resultSet, (Object)"JDBC ResultSet object cannot be null");
        Preconditions.checkNotNull((Object)config, (Object)"The configuration cannot be null");
        return ArrowVectorIterator.create(resultSet, config);
    }
}

