/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.binder;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.arrow.adapter.jdbc.binder.BaseColumnBinder;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.impl.UnionListReader;
import org.apache.arrow.vector.util.Text;

public class ListBinder
extends BaseColumnBinder<ListVector> {
    private final UnionListReader listReader;
    private final Class<?> arrayElementClass;
    private final boolean isTextColumn;

    public ListBinder(ListVector vector) {
        this(vector, 2003);
    }

    public ListBinder(ListVector vector, int jdbcType) {
        super(vector, jdbcType);
        this.listReader = vector.getReader();
        Class dataVectorClass = vector.getDataVector().getClass();
        try {
            this.arrayElementClass = dataVectorClass.getMethod("getObject", Integer.TYPE).getReturnType();
        }
        catch (NoSuchMethodException e) {
            String message = String.format("Issue to determine type for getObject method of data vector class %s ", dataVectorClass.getName());
            throw new RuntimeException(message);
        }
        this.isTextColumn = this.arrayElementClass.isAssignableFrom(Text.class);
    }

    @Override
    public void bind(PreparedStatement statement, int parameterIndex, int rowIndex) throws SQLException {
        Object array;
        this.listReader.setPosition(rowIndex);
        ArrayList sourceArray = (ArrayList)this.listReader.readObject();
        if (!this.isTextColumn) {
            array = Array.newInstance(this.arrayElementClass, sourceArray.size());
            Arrays.setAll((Object[])array, sourceArray::get);
        } else {
            array = new String[sourceArray.size()];
            Arrays.setAll((Object[])array, idx -> sourceArray.get(idx) != null ? sourceArray.get(idx).toString() : null);
        }
        statement.setObject(parameterIndex, array);
    }
}

