/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.impl.UnionMapWriter;
import org.apache.arrow.vector.util.ObjectMapperFactory;

public class MapConsumer
extends BaseConsumer<MapVector> {
    private final UnionMapWriter writer;
    private final ObjectMapper objectMapper = ObjectMapperFactory.newObjectMapper();
    private final TypeReference<Map<String, String>> typeReference = new TypeReference<Map<String, String>>(){};
    private int currentRow;

    public static MapConsumer createConsumer(MapVector mapVector, int index, boolean nullable) {
        return new MapConsumer(mapVector, index);
    }

    public MapConsumer(MapVector vector, int index) {
        super(vector, index);
        this.writer = vector.getWriter();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void consume(ResultSet resultSet) throws SQLException, IOException {
        Object map = resultSet.getObject(this.columnIndexInResultSet);
        this.writer.setPosition(this.currentRow++);
        if (map != null) {
            if (map instanceof String) {
                this.writeJavaMapIntoVector((Map)this.objectMapper.readValue((String)map, this.typeReference));
                return;
            } else {
                if (!(map instanceof Map)) throw new IllegalArgumentException("Unknown type of map type column from JDBC " + map.getClass().getName());
                this.writeJavaMapIntoVector((Map)map);
            }
            return;
        } else {
            this.writer.writeNull();
        }
    }

    private void writeJavaMapIntoVector(Map<String, String> map) {
        BufferAllocator allocator = ((MapVector)this.vector).getAllocator();
        this.writer.startMap();
        map.forEach((key, value) -> {
            byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
            byte[] valueBytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : null;
            ArrowBuf keyBuf = allocator.buffer((long)keyBytes.length);
            Throwable throwable = null;
            try {
                ArrowBuf valueBuf = valueBytes != null ? allocator.buffer((long)valueBytes.length) : null;
                Throwable throwable2 = null;
                try {
                    this.writer.startEntry();
                    keyBuf.writeBytes(keyBytes);
                    this.writer.key().varChar().writeVarChar(0, keyBytes.length, keyBuf);
                    if (valueBytes != null) {
                        valueBuf.writeBytes(valueBytes);
                        this.writer.value().varChar().writeVarChar(0, valueBytes.length, valueBuf);
                    } else {
                        this.writer.value().varChar().writeNull();
                    }
                    this.writer.endEntry();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (valueBuf != null) {
                        MapConsumer.$closeResource(throwable2, (AutoCloseable)valueBuf);
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (keyBuf != null) {
                    MapConsumer.$closeResource(throwable, (AutoCloseable)keyBuf);
                }
            }
        });
        this.writer.endMap();
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

