/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.binder;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.adapter.jdbc.binder.BaseColumnBinder;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.impl.UnionMapReader;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.util.JsonStringHashMap;

public class MapBinder
extends BaseColumnBinder<MapVector> {
    private UnionMapReader reader;
    private final boolean isTextKey;
    private final boolean isTextValue;

    public MapBinder(MapVector vector) {
        this(vector, 12);
    }

    public MapBinder(MapVector vector, int jdbcType) {
        super(vector, jdbcType);
        this.reader = vector.getReader();
        List structField = Objects.requireNonNull(vector.getField()).getChildren();
        if (structField.size() != 1) {
            throw new IllegalArgumentException("Expected Struct field metadata inside Map field");
        }
        List keyValueFields = Objects.requireNonNull((Field)structField.get(0)).getChildren();
        if (keyValueFields.size() != 2) {
            throw new IllegalArgumentException("Expected two children fields inside nested Struct field in Map");
        }
        ArrowType keyType = Objects.requireNonNull((Field)keyValueFields.get(0)).getType();
        ArrowType valueType = Objects.requireNonNull((Field)keyValueFields.get(1)).getType();
        this.isTextKey = ArrowType.Utf8.INSTANCE.equals((Object)keyType);
        this.isTextValue = ArrowType.Utf8.INSTANCE.equals((Object)valueType);
    }

    @Override
    public void bind(PreparedStatement statement, int parameterIndex, int rowIndex) throws SQLException {
        this.reader.setPosition(rowIndex);
        JsonStringHashMap tags = new JsonStringHashMap();
        while (this.reader.next()) {
            Object key = this.reader.key().readObject();
            Object value = this.reader.value().readObject();
            tags.put(this.isTextKey && key != null ? key.toString() : key, this.isTextValue && value != null ? value.toString() : value);
        }
        switch (this.jdbcType) {
            case 12: {
                statement.setString(parameterIndex, tags.toString());
                break;
            }
            default: {
                statement.setObject(parameterIndex, tags);
            }
        }
    }
}

