/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.binder;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.binder.ColumnBinderArrowTypeVisitor;
import org.apache.arrow.adapter.jdbc.binder.NullableColumnBinder;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.types.pojo.ArrowType;

public interface ColumnBinder {
    public void bind(PreparedStatement var1, int var2, int var3) throws SQLException;

    public int getJdbcType();

    public FieldVector getVector();

    public static ColumnBinder forVector(FieldVector vector) {
        return ColumnBinder.forVector(vector, null);
    }

    public static ColumnBinder forVector(FieldVector vector, Integer jdbcType) {
        ColumnBinder binder = (ColumnBinder)vector.getField().getType().accept((ArrowType.ArrowTypeVisitor)new ColumnBinderArrowTypeVisitor(vector, jdbcType));
        if (vector.getField().isNullable()) {
            return new NullableColumnBinder(binder);
        }
        return binder;
    }
}

