/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.util.Calendar;
import java.util.Map;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;

public class JdbcToArrowConfigBuilder {
    private Calendar calendar = null;
    private BufferAllocator allocator = null;
    private boolean includeMetadata = false;
    private Map<Integer, JdbcFieldInfo> arraySubTypesByColumnIndex = null;
    private Map<String, JdbcFieldInfo> arraySubTypesByColumnName = null;
    private int targetBatchSize;

    public JdbcToArrowConfigBuilder() {
    }

    public JdbcToArrowConfigBuilder(BufferAllocator allocator, Calendar calendar) {
        this();
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory allocator cannot be null");
        this.allocator = allocator;
        this.calendar = calendar;
        this.includeMetadata = false;
        this.targetBatchSize = 1024;
    }

    public JdbcToArrowConfigBuilder(BufferAllocator allocator, Calendar calendar, boolean includeMetadata) {
        this(allocator, calendar);
        this.includeMetadata = includeMetadata;
    }

    public JdbcToArrowConfigBuilder setAllocator(BufferAllocator allocator) {
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory allocator cannot be null");
        this.allocator = allocator;
        return this;
    }

    public JdbcToArrowConfigBuilder setCalendar(Calendar calendar) {
        this.calendar = calendar;
        return this;
    }

    public JdbcToArrowConfigBuilder setIncludeMetadata(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
        return this;
    }

    public JdbcToArrowConfigBuilder setArraySubTypeByColumnIndexMap(Map<Integer, JdbcFieldInfo> map) {
        this.arraySubTypesByColumnIndex = map;
        return this;
    }

    public JdbcToArrowConfigBuilder setArraySubTypeByColumnNameMap(Map<String, JdbcFieldInfo> map) {
        this.arraySubTypesByColumnName = map;
        return this;
    }

    public JdbcToArrowConfigBuilder setTargetBatchSize(int targetBatchSize) {
        this.targetBatchSize = targetBatchSize;
        return this;
    }

    public JdbcToArrowConfig build() {
        return new JdbcToArrowConfig(this.allocator, this.calendar, this.includeMetadata, this.arraySubTypesByColumnIndex, this.arraySubTypesByColumnName, this.targetBatchSize);
    }
}

