/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import com.google.common.base.Preconditions;
import io.netty.buffer.ArrowBuf;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.holders.NullableBigIntHolder;
import org.apache.arrow.vector.holders.NullableBitHolder;
import org.apache.arrow.vector.holders.NullableDateMilliHolder;
import org.apache.arrow.vector.holders.NullableDecimalHolder;
import org.apache.arrow.vector.holders.NullableFloat4Holder;
import org.apache.arrow.vector.holders.NullableFloat8Holder;
import org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.vector.holders.NullableSmallIntHolder;
import org.apache.arrow.vector.holders.NullableTimeMilliHolder;
import org.apache.arrow.vector.holders.NullableTinyIntHolder;
import org.apache.arrow.vector.holders.NullableVarCharHolder;
import org.apache.arrow.vector.holders.VarBinaryHolder;
import org.apache.arrow.vector.holders.VarCharHolder;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.DecimalUtility;

public class JdbcToArrowUtils {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private static final int DEFAULT_STREAM_BUFFER_SIZE = 1024;
    private static final int DEFAULT_CLOB_SUBSTRING_READ_SIZE = 256;
    private static final int JDBC_ARRAY_VALUE_COLUMN = 2;

    public static Calendar getUtcCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
    }

    public static Schema jdbcToArrowSchema(ResultSetMetaData rsmd, Calendar calendar) throws SQLException {
        Preconditions.checkNotNull((Object)rsmd, (Object)"JDBC ResultSetMetaData object can't be null");
        Preconditions.checkNotNull((Object)calendar, (Object)"Calendar object can't be null");
        return JdbcToArrowUtils.jdbcToArrowSchema(rsmd, new JdbcToArrowConfig((BaseAllocator)new RootAllocator(0L), calendar));
    }

    public static Schema jdbcToArrowSchema(ResultSetMetaData rsmd, JdbcToArrowConfig config) throws SQLException {
        Preconditions.checkNotNull((Object)rsmd, (Object)"JDBC ResultSetMetaData object can't be null");
        Preconditions.checkNotNull((Object)config, (Object)"The configuration object must not be null");
        ArrayList<Field> fields = new ArrayList<Field>();
        int columnCount = rsmd.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            HashMap<String, String> metadata;
            String columnName = rsmd.getColumnName(i);
            if (config.shouldIncludeMetadata()) {
                metadata = new HashMap<String, String>();
                metadata.put("SQL_CATALOG_NAME", rsmd.getCatalogName(i));
                metadata.put("SQL_TABLE_NAME", rsmd.getTableName(i));
                metadata.put("SQL_COLUMN_NAME", columnName);
                metadata.put("SQL_TYPE", rsmd.getColumnTypeName(i));
            } else {
                metadata = null;
            }
            ArrowType arrowType = JdbcToArrowUtils.getArrowTypeForJdbcField(new JdbcFieldInfo(rsmd, i), config.getCalendar());
            if (arrowType == null) continue;
            FieldType fieldType = new FieldType(true, arrowType, null, metadata);
            ArrayList<Field> children = null;
            if (arrowType.getTypeID() == ArrowType.List.TYPE_TYPE) {
                JdbcFieldInfo arrayFieldInfo = JdbcToArrowUtils.getJdbcFieldInfoForArraySubType(rsmd, i, config);
                if (arrayFieldInfo == null) {
                    throw new IllegalArgumentException("Configuration does not provide a mapping for array column " + i);
                }
                children = new ArrayList<Field>();
                ArrowType childType = JdbcToArrowUtils.getArrowTypeForJdbcField(arrayFieldInfo, config.getCalendar());
                children.add(new Field("child", FieldType.nullable((ArrowType)childType), null));
            }
            fields.add(new Field(columnName, fieldType, children));
        }
        return new Schema(fields, null);
    }

    public static ArrowType getArrowTypeForJdbcField(JdbcFieldInfo fieldInfo, Calendar calendar) {
        ArrowType.Bool arrowType;
        Preconditions.checkNotNull((Object)fieldInfo, (Object)"JdbcFieldInfo object cannot be null");
        String timezone = calendar != null ? calendar.getTimeZone().getID() : null;
        switch (fieldInfo.getJdbcType()) {
            case -7: 
            case 16: {
                arrowType = new ArrowType.Bool();
                break;
            }
            case -6: {
                arrowType = new ArrowType.Int(8, true);
                break;
            }
            case 5: {
                arrowType = new ArrowType.Int(16, true);
                break;
            }
            case 4: {
                arrowType = new ArrowType.Int(32, true);
                break;
            }
            case -5: {
                arrowType = new ArrowType.Int(64, true);
                break;
            }
            case 2: 
            case 3: {
                int precision = fieldInfo.getPrecision();
                int scale = fieldInfo.getScale();
                arrowType = new ArrowType.Decimal(precision, scale);
                break;
            }
            case 6: 
            case 7: {
                arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
                break;
            }
            case 8: {
                arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                arrowType = new ArrowType.Utf8();
                break;
            }
            case 91: {
                arrowType = new ArrowType.Date(DateUnit.MILLISECOND);
                break;
            }
            case 92: {
                arrowType = new ArrowType.Time(TimeUnit.MILLISECOND, 32);
                break;
            }
            case 93: {
                arrowType = new ArrowType.Timestamp(TimeUnit.MILLISECOND, timezone);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                arrowType = new ArrowType.Binary();
                break;
            }
            case 2003: {
                arrowType = new ArrowType.List();
                break;
            }
            default: {
                arrowType = null;
            }
        }
        return arrowType;
    }

    private static JdbcFieldInfo getJdbcFieldInfoForArraySubType(ResultSetMetaData rsmd, int arrayColumn, JdbcToArrowConfig config) throws SQLException {
        Preconditions.checkNotNull((Object)rsmd, (Object)"ResultSet MetaData object cannot be null");
        Preconditions.checkNotNull((Object)config, (Object)"Configuration must not be null");
        Preconditions.checkArgument((arrayColumn > 0 ? 1 : 0) != 0, (Object)"ResultSetMetaData columns start with 1; column cannot be less than 1");
        Preconditions.checkArgument((arrayColumn <= rsmd.getColumnCount() ? 1 : 0) != 0, (Object)"Column number cannot be more than the number of columns");
        JdbcFieldInfo fieldInfo = config.getArraySubTypeByColumnIndex(arrayColumn);
        if (fieldInfo == null) {
            fieldInfo = config.getArraySubTypeByColumnName(rsmd.getColumnName(arrayColumn));
        }
        return fieldInfo;
    }

    private static void allocateVectors(VectorSchemaRoot root, int size) {
        List vectors = root.getFieldVectors();
        for (FieldVector fieldVector : vectors) {
            if (fieldVector instanceof BaseFixedWidthVector) {
                ((BaseFixedWidthVector)fieldVector).allocateNew(size);
            } else {
                fieldVector.allocateNew();
            }
            fieldVector.setInitialCapacity(size);
        }
    }

    public static void jdbcToArrowVectors(ResultSet rs, VectorSchemaRoot root, Calendar calendar) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)rs, (Object)"JDBC ResultSet object can't be null");
        Preconditions.checkNotNull((Object)root, (Object)"Vector Schema cannot be null");
        Preconditions.checkNotNull((Object)calendar, (Object)"Calendar object can't be null");
        JdbcToArrowUtils.jdbcToArrowVectors(rs, root, new JdbcToArrowConfig((BaseAllocator)new RootAllocator(0L), calendar));
    }

    public static void jdbcToArrowVectors(ResultSet rs, VectorSchemaRoot root, JdbcToArrowConfig config) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)rs, (Object)"JDBC ResultSet object can't be null");
        Preconditions.checkNotNull((Object)root, (Object)"JDBC ResultSet object can't be null");
        Preconditions.checkNotNull((Object)config, (Object)"JDBC-to-Arrow configuration cannot be null");
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        JdbcToArrowUtils.allocateVectors(root, 256);
        int rowCount = 0;
        while (rs.next()) {
            for (int i = 1; i <= columnCount; ++i) {
                JdbcToArrowUtils.jdbcToFieldVector(rs, i, rs.getMetaData().getColumnType(i), rowCount, root.getVector(rsmd.getColumnName(i)), config);
            }
            ++rowCount;
        }
        root.setRowCount(rowCount);
    }

    private static void jdbcToFieldVector(ResultSet rs, int columnIndex, int jdbcColType, int rowCount, FieldVector vector, JdbcToArrowConfig config) throws SQLException, IOException {
        Calendar calendar = config.getCalendar();
        switch (jdbcColType) {
            case -7: 
            case 16: {
                JdbcToArrowUtils.updateVector((BitVector)vector, rs.getBoolean(columnIndex), !rs.wasNull(), rowCount);
                break;
            }
            case -6: {
                JdbcToArrowUtils.updateVector((TinyIntVector)vector, rs.getInt(columnIndex), !rs.wasNull(), rowCount);
                break;
            }
            case 5: {
                JdbcToArrowUtils.updateVector((SmallIntVector)vector, rs.getInt(columnIndex), !rs.wasNull(), rowCount);
                break;
            }
            case 4: {
                JdbcToArrowUtils.updateVector((IntVector)vector, rs.getInt(columnIndex), !rs.wasNull(), rowCount);
                break;
            }
            case -5: {
                JdbcToArrowUtils.updateVector((BigIntVector)vector, rs.getLong(columnIndex), !rs.wasNull(), rowCount);
                break;
            }
            case 2: 
            case 3: {
                JdbcToArrowUtils.updateVector((DecimalVector)vector, rs.getBigDecimal(columnIndex), !rs.wasNull(), rowCount);
                break;
            }
            case 6: 
            case 7: {
                JdbcToArrowUtils.updateVector((Float4Vector)vector, rs.getFloat(columnIndex), !rs.wasNull(), rowCount);
                break;
            }
            case 8: {
                JdbcToArrowUtils.updateVector((Float8Vector)vector, rs.getDouble(columnIndex), !rs.wasNull(), rowCount);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                JdbcToArrowUtils.updateVector((VarCharVector)vector, rs.getString(columnIndex), !rs.wasNull(), rowCount);
                break;
            }
            case 91: {
                Date date = calendar != null ? rs.getDate(columnIndex, calendar) : rs.getDate(columnIndex);
                JdbcToArrowUtils.updateVector((DateMilliVector)vector, date, !rs.wasNull(), rowCount);
                break;
            }
            case 92: {
                Time time = calendar != null ? rs.getTime(columnIndex, calendar) : rs.getTime(columnIndex);
                JdbcToArrowUtils.updateVector((TimeMilliVector)vector, time, !rs.wasNull(), rowCount);
                break;
            }
            case 93: {
                Timestamp ts = calendar != null ? rs.getTimestamp(columnIndex, calendar) : rs.getTimestamp(columnIndex);
                JdbcToArrowUtils.updateVector((TimeStampVector)vector, ts, !rs.wasNull(), rowCount);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                JdbcToArrowUtils.updateVector((VarBinaryVector)vector, rs.getBinaryStream(columnIndex), !rs.wasNull(), rowCount);
                break;
            }
            case 2003: {
                JdbcToArrowUtils.updateVector((ListVector)vector, rs, columnIndex, rowCount, config);
                break;
            }
            case 2005: {
                JdbcToArrowUtils.updateVector((VarCharVector)vector, rs.getClob(columnIndex), !rs.wasNull(), rowCount);
                break;
            }
            case 2004: {
                JdbcToArrowUtils.updateVector((VarBinaryVector)vector, rs.getBlob(columnIndex), !rs.wasNull(), rowCount);
                break;
            }
        }
    }

    private static void updateVector(BitVector bitVector, boolean value, boolean isNonNull, int rowCount) {
        NullableBitHolder holder = new NullableBitHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = value ? 1 : 0;
        }
        bitVector.setSafe(rowCount, holder);
        bitVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(TinyIntVector tinyIntVector, int value, boolean isNonNull, int rowCount) {
        NullableTinyIntHolder holder = new NullableTinyIntHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = (byte)value;
        }
        tinyIntVector.setSafe(rowCount, holder);
        tinyIntVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(SmallIntVector smallIntVector, int value, boolean isNonNull, int rowCount) {
        NullableSmallIntHolder holder = new NullableSmallIntHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = (short)value;
        }
        smallIntVector.setSafe(rowCount, holder);
        smallIntVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(IntVector intVector, int value, boolean isNonNull, int rowCount) {
        NullableIntHolder holder = new NullableIntHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = value;
        }
        intVector.setSafe(rowCount, holder);
        intVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(BigIntVector bigIntVector, long value, boolean isNonNull, int rowCount) {
        NullableBigIntHolder holder = new NullableBigIntHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = value;
        }
        bigIntVector.setSafe(rowCount, holder);
        bigIntVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(DecimalVector decimalVector, BigDecimal value, boolean isNonNull, int rowCount) {
        NullableDecimalHolder holder = new NullableDecimalHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.precision = value.precision();
            holder.scale = value.scale();
            holder.buffer = decimalVector.getAllocator().buffer(256);
            holder.start = 0;
            DecimalUtility.writeBigDecimalToArrowBuf((BigDecimal)value, (ArrowBuf)holder.buffer, (int)holder.start);
        }
        decimalVector.setSafe(rowCount, holder);
        decimalVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(Float4Vector float4Vector, float value, boolean isNonNull, int rowCount) {
        NullableFloat4Holder holder = new NullableFloat4Holder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = value;
        }
        float4Vector.setSafe(rowCount, holder);
        float4Vector.setValueCount(rowCount + 1);
    }

    private static void updateVector(Float8Vector float8Vector, double value, boolean isNonNull, int rowCount) {
        NullableFloat8Holder holder = new NullableFloat8Holder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = value;
        }
        float8Vector.setSafe(rowCount, holder);
        float8Vector.setValueCount(rowCount + 1);
    }

    private static void updateVector(VarCharVector varcharVector, String value, boolean isNonNull, int rowCount) {
        NullableVarCharHolder holder = new NullableVarCharHolder();
        holder.isSet = isNonNull ? 1 : 0;
        varcharVector.setIndexDefined(rowCount);
        if (isNonNull) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            holder.buffer = varcharVector.getAllocator().buffer(bytes.length);
            holder.buffer.setBytes(0, bytes, 0, bytes.length);
            holder.start = 0;
            holder.end = bytes.length;
        } else {
            holder.buffer = varcharVector.getAllocator().buffer(0);
        }
        varcharVector.setSafe(rowCount, holder);
        varcharVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(DateMilliVector dateMilliVector, Date date, boolean isNonNull, int rowCount) {
        NullableDateMilliHolder holder = new NullableDateMilliHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = date.getTime();
        }
        dateMilliVector.setSafe(rowCount, holder);
        dateMilliVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(TimeMilliVector timeMilliVector, Time time, boolean isNonNull, int rowCount) {
        NullableTimeMilliHolder holder = new NullableTimeMilliHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull && time != null) {
            holder.value = (int)time.getTime();
        }
        timeMilliVector.setSafe(rowCount, holder);
        timeMilliVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(TimeStampVector timeStampVector, Timestamp timestamp, boolean isNonNull, int rowCount) {
        timeStampVector.setValueCount(rowCount + 1);
        if (timestamp != null) {
            timeStampVector.setSafe(rowCount, timestamp.getTime());
        } else {
            timeStampVector.setNull(rowCount);
        }
    }

    private static void updateVector(VarBinaryVector varBinaryVector, InputStream is, boolean isNonNull, int rowCount) throws IOException {
        varBinaryVector.setValueCount(rowCount + 1);
        if (isNonNull && is != null) {
            int read;
            VarBinaryHolder holder = new VarBinaryHolder();
            ArrowBuf arrowBuf = varBinaryVector.getDataBuffer();
            holder.start = 0;
            byte[] bytes = new byte[1024];
            int total = 0;
            while ((read = is.read(bytes, 0, 1024)) != -1) {
                arrowBuf.setBytes(total, bytes, total, read);
                total += read;
            }
            holder.end = total;
            holder.buffer = arrowBuf;
            varBinaryVector.set(rowCount, holder);
            varBinaryVector.setIndexDefined(rowCount);
        } else {
            varBinaryVector.setNull(rowCount);
        }
    }

    private static void updateVector(VarCharVector varcharVector, Clob clob, boolean isNonNull, int rowCount) throws SQLException, IOException {
        varcharVector.setValueCount(rowCount + 1);
        if (isNonNull && clob != null) {
            VarCharHolder holder = new VarCharHolder();
            ArrowBuf arrowBuf = varcharVector.getDataBuffer();
            holder.start = 0;
            long length = clob.length();
            int read = 1;
            int readSize = length < 256L ? (int)length : 256;
            int totalBytes = 0;
            while ((long)read <= length) {
                String str = clob.getSubString(read, readSize);
                byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
                arrowBuf.setBytes(totalBytes, (InputStream)new ByteArrayInputStream(bytes, 0, bytes.length), bytes.length);
                totalBytes += bytes.length;
                read += readSize;
            }
            holder.end = totalBytes;
            holder.buffer = arrowBuf;
            varcharVector.set(rowCount, holder);
            varcharVector.setIndexDefined(rowCount);
        } else {
            varcharVector.setNull(rowCount);
        }
    }

    private static void updateVector(VarBinaryVector varBinaryVector, Blob blob, boolean isNonNull, int rowCount) throws SQLException, IOException {
        JdbcToArrowUtils.updateVector(varBinaryVector, blob != null ? blob.getBinaryStream() : null, isNonNull, rowCount);
    }

    private static void updateVector(ListVector listVector, ResultSet resultSet, int arrayIndex, int rowCount, JdbcToArrowConfig config) throws SQLException, IOException {
        JdbcFieldInfo fieldInfo = JdbcToArrowUtils.getJdbcFieldInfoForArraySubType(resultSet.getMetaData(), arrayIndex, config);
        if (fieldInfo == null) {
            throw new IllegalArgumentException("Column " + arrayIndex + " is an array of unknown type.");
        }
        int valueCount = listVector.getValueCount();
        Array array = resultSet.getArray(arrayIndex);
        FieldVector fieldVector = listVector.getDataVector();
        int arrayRowCount = 0;
        if (!resultSet.wasNull()) {
            listVector.startNewValue(rowCount);
            try (ResultSet rs = array.getResultSet();){
                while (rs.next()) {
                    JdbcToArrowUtils.jdbcToFieldVector(rs, 2, fieldInfo.getJdbcType(), valueCount + arrayRowCount, fieldVector, config);
                    ++arrayRowCount;
                }
            }
            listVector.endValue(rowCount, arrayRowCount);
        }
        listVector.setValueCount(valueCount + arrayRowCount);
    }
}

